/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.thrift.TExpr;
import org.apache.doris.thrift.TRuntimeFilterType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TRuntimeFilterDesc
implements TBase<TRuntimeFilterDesc, _Fields>,
Serializable,
Cloneable,
Comparable<TRuntimeFilterDesc> {
    private static final TStruct STRUCT_DESC = new TStruct("TRuntimeFilterDesc");
    private static final TField FILTER_ID_FIELD_DESC = new TField("filter_id", 8, 1);
    private static final TField SRC_EXPR_FIELD_DESC = new TField("src_expr", 12, 2);
    private static final TField EXPR_ORDER_FIELD_DESC = new TField("expr_order", 8, 3);
    private static final TField PLAN_ID_TO_TARGET_EXPR_FIELD_DESC = new TField("planId_to_target_expr", 13, 4);
    private static final TField IS_BROADCAST_JOIN_FIELD_DESC = new TField("is_broadcast_join", 2, 5);
    private static final TField HAS_LOCAL_TARGETS_FIELD_DESC = new TField("has_local_targets", 2, 6);
    private static final TField HAS_REMOTE_TARGETS_FIELD_DESC = new TField("has_remote_targets", 2, 7);
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 8);
    private static final TField BLOOM_FILTER_SIZE_BYTES_FIELD_DESC = new TField("bloom_filter_size_bytes", 10, 9);
    private static final TField BITMAP_TARGET_EXPR_FIELD_DESC = new TField("bitmap_target_expr", 12, 10);
    private static final TField BITMAP_FILTER_NOT_IN_FIELD_DESC = new TField("bitmap_filter_not_in", 2, 11);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TRuntimeFilterDescStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TRuntimeFilterDescTupleSchemeFactory();
    public int filter_id;
    @Nullable
    public TExpr src_expr;
    public int expr_order;
    @Nullable
    public Map<Integer, TExpr> planId_to_target_expr;
    public boolean is_broadcast_join;
    public boolean has_local_targets;
    public boolean has_remote_targets;
    @Nullable
    public TRuntimeFilterType type;
    public long bloom_filter_size_bytes;
    @Nullable
    public TExpr bitmap_target_expr;
    public boolean bitmap_filter_not_in;
    private static final int __FILTER_ID_ISSET_ID = 0;
    private static final int __EXPR_ORDER_ISSET_ID = 1;
    private static final int __IS_BROADCAST_JOIN_ISSET_ID = 2;
    private static final int __HAS_LOCAL_TARGETS_ISSET_ID = 3;
    private static final int __HAS_REMOTE_TARGETS_ISSET_ID = 4;
    private static final int __BLOOM_FILTER_SIZE_BYTES_ISSET_ID = 5;
    private static final int __BITMAP_FILTER_NOT_IN_ISSET_ID = 6;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.BLOOM_FILTER_SIZE_BYTES, _Fields.BITMAP_TARGET_EXPR, _Fields.BITMAP_FILTER_NOT_IN};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TRuntimeFilterDesc() {
    }

    public TRuntimeFilterDesc(int filter_id, TExpr src_expr, int expr_order, Map<Integer, TExpr> planId_to_target_expr, boolean is_broadcast_join, boolean has_local_targets, boolean has_remote_targets, TRuntimeFilterType type) {
        this();
        this.filter_id = filter_id;
        this.setFilterIdIsSet(true);
        this.src_expr = src_expr;
        this.expr_order = expr_order;
        this.setExprOrderIsSet(true);
        this.planId_to_target_expr = planId_to_target_expr;
        this.is_broadcast_join = is_broadcast_join;
        this.setIsBroadcastJoinIsSet(true);
        this.has_local_targets = has_local_targets;
        this.setHasLocalTargetsIsSet(true);
        this.has_remote_targets = has_remote_targets;
        this.setHasRemoteTargetsIsSet(true);
        this.type = type;
    }

    public TRuntimeFilterDesc(TRuntimeFilterDesc other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.filter_id = other.filter_id;
        if (other.isSetSrcExpr()) {
            this.src_expr = new TExpr(other.src_expr);
        }
        this.expr_order = other.expr_order;
        if (other.isSetPlanIdToTargetExpr()) {
            HashMap<Integer, TExpr> __this__planId_to_target_expr = new HashMap<Integer, TExpr>(other.planId_to_target_expr.size());
            for (Map.Entry<Integer, TExpr> other_element : other.planId_to_target_expr.entrySet()) {
                Integer other_element_key = other_element.getKey();
                TExpr other_element_value = other_element.getValue();
                Integer __this__planId_to_target_expr_copy_key = other_element_key;
                TExpr __this__planId_to_target_expr_copy_value = new TExpr(other_element_value);
                __this__planId_to_target_expr.put(__this__planId_to_target_expr_copy_key, __this__planId_to_target_expr_copy_value);
            }
            this.planId_to_target_expr = __this__planId_to_target_expr;
        }
        this.is_broadcast_join = other.is_broadcast_join;
        this.has_local_targets = other.has_local_targets;
        this.has_remote_targets = other.has_remote_targets;
        if (other.isSetType()) {
            this.type = other.type;
        }
        this.bloom_filter_size_bytes = other.bloom_filter_size_bytes;
        if (other.isSetBitmapTargetExpr()) {
            this.bitmap_target_expr = new TExpr(other.bitmap_target_expr);
        }
        this.bitmap_filter_not_in = other.bitmap_filter_not_in;
    }

    public TRuntimeFilterDesc deepCopy() {
        return new TRuntimeFilterDesc(this);
    }

    public void clear() {
        this.setFilterIdIsSet(false);
        this.filter_id = 0;
        this.src_expr = null;
        this.setExprOrderIsSet(false);
        this.expr_order = 0;
        this.planId_to_target_expr = null;
        this.setIsBroadcastJoinIsSet(false);
        this.is_broadcast_join = false;
        this.setHasLocalTargetsIsSet(false);
        this.has_local_targets = false;
        this.setHasRemoteTargetsIsSet(false);
        this.has_remote_targets = false;
        this.type = null;
        this.setBloomFilterSizeBytesIsSet(false);
        this.bloom_filter_size_bytes = 0L;
        this.bitmap_target_expr = null;
        this.setBitmapFilterNotInIsSet(false);
        this.bitmap_filter_not_in = false;
    }

    public int getFilterId() {
        return this.filter_id;
    }

    public TRuntimeFilterDesc setFilterId(int filter_id) {
        this.filter_id = filter_id;
        this.setFilterIdIsSet(true);
        return this;
    }

    public void unsetFilterId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetFilterId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setFilterIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public TExpr getSrcExpr() {
        return this.src_expr;
    }

    public TRuntimeFilterDesc setSrcExpr(@Nullable TExpr src_expr) {
        this.src_expr = src_expr;
        return this;
    }

    public void unsetSrcExpr() {
        this.src_expr = null;
    }

    public boolean isSetSrcExpr() {
        return this.src_expr != null;
    }

    public void setSrcExprIsSet(boolean value) {
        if (!value) {
            this.src_expr = null;
        }
    }

    public int getExprOrder() {
        return this.expr_order;
    }

    public TRuntimeFilterDesc setExprOrder(int expr_order) {
        this.expr_order = expr_order;
        this.setExprOrderIsSet(true);
        return this;
    }

    public void unsetExprOrder() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetExprOrder() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setExprOrderIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getPlanIdToTargetExprSize() {
        return this.planId_to_target_expr == null ? 0 : this.planId_to_target_expr.size();
    }

    public void putToPlanIdToTargetExpr(int key, TExpr val) {
        if (this.planId_to_target_expr == null) {
            this.planId_to_target_expr = new HashMap<Integer, TExpr>();
        }
        this.planId_to_target_expr.put(key, val);
    }

    @Nullable
    public Map<Integer, TExpr> getPlanIdToTargetExpr() {
        return this.planId_to_target_expr;
    }

    public TRuntimeFilterDesc setPlanIdToTargetExpr(@Nullable Map<Integer, TExpr> planId_to_target_expr) {
        this.planId_to_target_expr = planId_to_target_expr;
        return this;
    }

    public void unsetPlanIdToTargetExpr() {
        this.planId_to_target_expr = null;
    }

    public boolean isSetPlanIdToTargetExpr() {
        return this.planId_to_target_expr != null;
    }

    public void setPlanIdToTargetExprIsSet(boolean value) {
        if (!value) {
            this.planId_to_target_expr = null;
        }
    }

    public boolean isIsBroadcastJoin() {
        return this.is_broadcast_join;
    }

    public TRuntimeFilterDesc setIsBroadcastJoin(boolean is_broadcast_join) {
        this.is_broadcast_join = is_broadcast_join;
        this.setIsBroadcastJoinIsSet(true);
        return this;
    }

    public void unsetIsBroadcastJoin() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetIsBroadcastJoin() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setIsBroadcastJoinIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public boolean isHasLocalTargets() {
        return this.has_local_targets;
    }

    public TRuntimeFilterDesc setHasLocalTargets(boolean has_local_targets) {
        this.has_local_targets = has_local_targets;
        this.setHasLocalTargetsIsSet(true);
        return this;
    }

    public void unsetHasLocalTargets() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetHasLocalTargets() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setHasLocalTargetsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public boolean isHasRemoteTargets() {
        return this.has_remote_targets;
    }

    public TRuntimeFilterDesc setHasRemoteTargets(boolean has_remote_targets) {
        this.has_remote_targets = has_remote_targets;
        this.setHasRemoteTargetsIsSet(true);
        return this;
    }

    public void unsetHasRemoteTargets() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetHasRemoteTargets() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setHasRemoteTargetsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    @Nullable
    public TRuntimeFilterType getType() {
        return this.type;
    }

    public TRuntimeFilterDesc setType(@Nullable TRuntimeFilterType type) {
        this.type = type;
        return this;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public long getBloomFilterSizeBytes() {
        return this.bloom_filter_size_bytes;
    }

    public TRuntimeFilterDesc setBloomFilterSizeBytes(long bloom_filter_size_bytes) {
        this.bloom_filter_size_bytes = bloom_filter_size_bytes;
        this.setBloomFilterSizeBytesIsSet(true);
        return this;
    }

    public void unsetBloomFilterSizeBytes() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)5);
    }

    public boolean isSetBloomFilterSizeBytes() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)5);
    }

    public void setBloomFilterSizeBytesIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)5, (boolean)value);
    }

    @Nullable
    public TExpr getBitmapTargetExpr() {
        return this.bitmap_target_expr;
    }

    public TRuntimeFilterDesc setBitmapTargetExpr(@Nullable TExpr bitmap_target_expr) {
        this.bitmap_target_expr = bitmap_target_expr;
        return this;
    }

    public void unsetBitmapTargetExpr() {
        this.bitmap_target_expr = null;
    }

    public boolean isSetBitmapTargetExpr() {
        return this.bitmap_target_expr != null;
    }

    public void setBitmapTargetExprIsSet(boolean value) {
        if (!value) {
            this.bitmap_target_expr = null;
        }
    }

    public boolean isBitmapFilterNotIn() {
        return this.bitmap_filter_not_in;
    }

    public TRuntimeFilterDesc setBitmapFilterNotIn(boolean bitmap_filter_not_in) {
        this.bitmap_filter_not_in = bitmap_filter_not_in;
        this.setBitmapFilterNotInIsSet(true);
        return this;
    }

    public void unsetBitmapFilterNotIn() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)6);
    }

    public boolean isSetBitmapFilterNotIn() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)6);
    }

    public void setBitmapFilterNotInIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case FILTER_ID: {
                if (value == null) {
                    this.unsetFilterId();
                    break;
                }
                this.setFilterId((Integer)value);
                break;
            }
            case SRC_EXPR: {
                if (value == null) {
                    this.unsetSrcExpr();
                    break;
                }
                this.setSrcExpr((TExpr)value);
                break;
            }
            case EXPR_ORDER: {
                if (value == null) {
                    this.unsetExprOrder();
                    break;
                }
                this.setExprOrder((Integer)value);
                break;
            }
            case PLAN_ID_TO_TARGET_EXPR: {
                if (value == null) {
                    this.unsetPlanIdToTargetExpr();
                    break;
                }
                this.setPlanIdToTargetExpr((Map)value);
                break;
            }
            case IS_BROADCAST_JOIN: {
                if (value == null) {
                    this.unsetIsBroadcastJoin();
                    break;
                }
                this.setIsBroadcastJoin((Boolean)value);
                break;
            }
            case HAS_LOCAL_TARGETS: {
                if (value == null) {
                    this.unsetHasLocalTargets();
                    break;
                }
                this.setHasLocalTargets((Boolean)value);
                break;
            }
            case HAS_REMOTE_TARGETS: {
                if (value == null) {
                    this.unsetHasRemoteTargets();
                    break;
                }
                this.setHasRemoteTargets((Boolean)value);
                break;
            }
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((TRuntimeFilterType)((Object)value));
                break;
            }
            case BLOOM_FILTER_SIZE_BYTES: {
                if (value == null) {
                    this.unsetBloomFilterSizeBytes();
                    break;
                }
                this.setBloomFilterSizeBytes((Long)value);
                break;
            }
            case BITMAP_TARGET_EXPR: {
                if (value == null) {
                    this.unsetBitmapTargetExpr();
                    break;
                }
                this.setBitmapTargetExpr((TExpr)value);
                break;
            }
            case BITMAP_FILTER_NOT_IN: {
                if (value == null) {
                    this.unsetBitmapFilterNotIn();
                    break;
                }
                this.setBitmapFilterNotIn((Boolean)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case FILTER_ID: {
                return this.getFilterId();
            }
            case SRC_EXPR: {
                return this.getSrcExpr();
            }
            case EXPR_ORDER: {
                return this.getExprOrder();
            }
            case PLAN_ID_TO_TARGET_EXPR: {
                return this.getPlanIdToTargetExpr();
            }
            case IS_BROADCAST_JOIN: {
                return this.isIsBroadcastJoin();
            }
            case HAS_LOCAL_TARGETS: {
                return this.isHasLocalTargets();
            }
            case HAS_REMOTE_TARGETS: {
                return this.isHasRemoteTargets();
            }
            case TYPE: {
                return this.getType();
            }
            case BLOOM_FILTER_SIZE_BYTES: {
                return this.getBloomFilterSizeBytes();
            }
            case BITMAP_TARGET_EXPR: {
                return this.getBitmapTargetExpr();
            }
            case BITMAP_FILTER_NOT_IN: {
                return this.isBitmapFilterNotIn();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case FILTER_ID: {
                return this.isSetFilterId();
            }
            case SRC_EXPR: {
                return this.isSetSrcExpr();
            }
            case EXPR_ORDER: {
                return this.isSetExprOrder();
            }
            case PLAN_ID_TO_TARGET_EXPR: {
                return this.isSetPlanIdToTargetExpr();
            }
            case IS_BROADCAST_JOIN: {
                return this.isSetIsBroadcastJoin();
            }
            case HAS_LOCAL_TARGETS: {
                return this.isSetHasLocalTargets();
            }
            case HAS_REMOTE_TARGETS: {
                return this.isSetHasRemoteTargets();
            }
            case TYPE: {
                return this.isSetType();
            }
            case BLOOM_FILTER_SIZE_BYTES: {
                return this.isSetBloomFilterSizeBytes();
            }
            case BITMAP_TARGET_EXPR: {
                return this.isSetBitmapTargetExpr();
            }
            case BITMAP_FILTER_NOT_IN: {
                return this.isSetBitmapFilterNotIn();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TRuntimeFilterDesc) {
            return this.equals((TRuntimeFilterDesc)that);
        }
        return false;
    }

    public boolean equals(TRuntimeFilterDesc that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_filter_id = true;
        boolean that_present_filter_id = true;
        if (this_present_filter_id || that_present_filter_id) {
            if (!this_present_filter_id || !that_present_filter_id) {
                return false;
            }
            if (this.filter_id != that.filter_id) {
                return false;
            }
        }
        boolean this_present_src_expr = this.isSetSrcExpr();
        boolean that_present_src_expr = that.isSetSrcExpr();
        if (this_present_src_expr || that_present_src_expr) {
            if (!this_present_src_expr || !that_present_src_expr) {
                return false;
            }
            if (!this.src_expr.equals(that.src_expr)) {
                return false;
            }
        }
        boolean this_present_expr_order = true;
        boolean that_present_expr_order = true;
        if (this_present_expr_order || that_present_expr_order) {
            if (!this_present_expr_order || !that_present_expr_order) {
                return false;
            }
            if (this.expr_order != that.expr_order) {
                return false;
            }
        }
        boolean this_present_planId_to_target_expr = this.isSetPlanIdToTargetExpr();
        boolean that_present_planId_to_target_expr = that.isSetPlanIdToTargetExpr();
        if (this_present_planId_to_target_expr || that_present_planId_to_target_expr) {
            if (!this_present_planId_to_target_expr || !that_present_planId_to_target_expr) {
                return false;
            }
            if (!this.planId_to_target_expr.equals(that.planId_to_target_expr)) {
                return false;
            }
        }
        boolean this_present_is_broadcast_join = true;
        boolean that_present_is_broadcast_join = true;
        if (this_present_is_broadcast_join || that_present_is_broadcast_join) {
            if (!this_present_is_broadcast_join || !that_present_is_broadcast_join) {
                return false;
            }
            if (this.is_broadcast_join != that.is_broadcast_join) {
                return false;
            }
        }
        boolean this_present_has_local_targets = true;
        boolean that_present_has_local_targets = true;
        if (this_present_has_local_targets || that_present_has_local_targets) {
            if (!this_present_has_local_targets || !that_present_has_local_targets) {
                return false;
            }
            if (this.has_local_targets != that.has_local_targets) {
                return false;
            }
        }
        boolean this_present_has_remote_targets = true;
        boolean that_present_has_remote_targets = true;
        if (this_present_has_remote_targets || that_present_has_remote_targets) {
            if (!this_present_has_remote_targets || !that_present_has_remote_targets) {
                return false;
            }
            if (this.has_remote_targets != that.has_remote_targets) {
                return false;
            }
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_bloom_filter_size_bytes = this.isSetBloomFilterSizeBytes();
        boolean that_present_bloom_filter_size_bytes = that.isSetBloomFilterSizeBytes();
        if (this_present_bloom_filter_size_bytes || that_present_bloom_filter_size_bytes) {
            if (!this_present_bloom_filter_size_bytes || !that_present_bloom_filter_size_bytes) {
                return false;
            }
            if (this.bloom_filter_size_bytes != that.bloom_filter_size_bytes) {
                return false;
            }
        }
        boolean this_present_bitmap_target_expr = this.isSetBitmapTargetExpr();
        boolean that_present_bitmap_target_expr = that.isSetBitmapTargetExpr();
        if (this_present_bitmap_target_expr || that_present_bitmap_target_expr) {
            if (!this_present_bitmap_target_expr || !that_present_bitmap_target_expr) {
                return false;
            }
            if (!this.bitmap_target_expr.equals(that.bitmap_target_expr)) {
                return false;
            }
        }
        boolean this_present_bitmap_filter_not_in = this.isSetBitmapFilterNotIn();
        boolean that_present_bitmap_filter_not_in = that.isSetBitmapFilterNotIn();
        if (this_present_bitmap_filter_not_in || that_present_bitmap_filter_not_in) {
            if (!this_present_bitmap_filter_not_in || !that_present_bitmap_filter_not_in) {
                return false;
            }
            if (this.bitmap_filter_not_in != that.bitmap_filter_not_in) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + this.filter_id;
        hashCode = hashCode * 8191 + (this.isSetSrcExpr() ? 131071 : 524287);
        if (this.isSetSrcExpr()) {
            hashCode = hashCode * 8191 + this.src_expr.hashCode();
        }
        hashCode = hashCode * 8191 + this.expr_order;
        hashCode = hashCode * 8191 + (this.isSetPlanIdToTargetExpr() ? 131071 : 524287);
        if (this.isSetPlanIdToTargetExpr()) {
            hashCode = hashCode * 8191 + this.planId_to_target_expr.hashCode();
        }
        hashCode = hashCode * 8191 + (this.is_broadcast_join ? 131071 : 524287);
        hashCode = hashCode * 8191 + (this.has_local_targets ? 131071 : 524287);
        hashCode = hashCode * 8191 + (this.has_remote_targets ? 131071 : 524287);
        hashCode = hashCode * 8191 + (this.isSetType() ? 131071 : 524287);
        if (this.isSetType()) {
            hashCode = hashCode * 8191 + this.type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetBloomFilterSizeBytes() ? 131071 : 524287);
        if (this.isSetBloomFilterSizeBytes()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.bloom_filter_size_bytes);
        }
        hashCode = hashCode * 8191 + (this.isSetBitmapTargetExpr() ? 131071 : 524287);
        if (this.isSetBitmapTargetExpr()) {
            hashCode = hashCode * 8191 + this.bitmap_target_expr.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetBitmapFilterNotIn() ? 131071 : 524287);
        if (this.isSetBitmapFilterNotIn()) {
            hashCode = hashCode * 8191 + (this.bitmap_filter_not_in ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TRuntimeFilterDesc other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetFilterId()).compareTo(other.isSetFilterId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFilterId() && (lastComparison = TBaseHelper.compareTo((int)this.filter_id, (int)other.filter_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSrcExpr()).compareTo(other.isSetSrcExpr());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSrcExpr() && (lastComparison = TBaseHelper.compareTo((Comparable)this.src_expr, (Comparable)other.src_expr)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetExprOrder()).compareTo(other.isSetExprOrder());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExprOrder() && (lastComparison = TBaseHelper.compareTo((int)this.expr_order, (int)other.expr_order)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPlanIdToTargetExpr()).compareTo(other.isSetPlanIdToTargetExpr());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPlanIdToTargetExpr() && (lastComparison = TBaseHelper.compareTo(this.planId_to_target_expr, other.planId_to_target_expr)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIsBroadcastJoin()).compareTo(other.isSetIsBroadcastJoin());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsBroadcastJoin() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_broadcast_join, (boolean)other.is_broadcast_join)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHasLocalTargets()).compareTo(other.isSetHasLocalTargets());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHasLocalTargets() && (lastComparison = TBaseHelper.compareTo((boolean)this.has_local_targets, (boolean)other.has_local_targets)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHasRemoteTargets()).compareTo(other.isSetHasRemoteTargets());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHasRemoteTargets() && (lastComparison = TBaseHelper.compareTo((boolean)this.has_remote_targets, (boolean)other.has_remote_targets)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)other.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBloomFilterSizeBytes()).compareTo(other.isSetBloomFilterSizeBytes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBloomFilterSizeBytes() && (lastComparison = TBaseHelper.compareTo((long)this.bloom_filter_size_bytes, (long)other.bloom_filter_size_bytes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBitmapTargetExpr()).compareTo(other.isSetBitmapTargetExpr());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBitmapTargetExpr() && (lastComparison = TBaseHelper.compareTo((Comparable)this.bitmap_target_expr, (Comparable)other.bitmap_target_expr)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBitmapFilterNotIn()).compareTo(other.isSetBitmapFilterNotIn());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBitmapFilterNotIn() && (lastComparison = TBaseHelper.compareTo((boolean)this.bitmap_filter_not_in, (boolean)other.bitmap_filter_not_in)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TRuntimeFilterDesc.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TRuntimeFilterDesc.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TRuntimeFilterDesc(");
        boolean first = true;
        sb.append("filter_id:");
        sb.append(this.filter_id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("src_expr:");
        if (this.src_expr == null) {
            sb.append("null");
        } else {
            sb.append(this.src_expr);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("expr_order:");
        sb.append(this.expr_order);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("planId_to_target_expr:");
        if (this.planId_to_target_expr == null) {
            sb.append("null");
        } else {
            sb.append(this.planId_to_target_expr);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("is_broadcast_join:");
        sb.append(this.is_broadcast_join);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("has_local_targets:");
        sb.append(this.has_local_targets);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("has_remote_targets:");
        sb.append(this.has_remote_targets);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (this.isSetBloomFilterSizeBytes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bloom_filter_size_bytes:");
            sb.append(this.bloom_filter_size_bytes);
            first = false;
        }
        if (this.isSetBitmapTargetExpr()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bitmap_target_expr:");
            if (this.bitmap_target_expr == null) {
                sb.append("null");
            } else {
                sb.append(this.bitmap_target_expr);
            }
            first = false;
        }
        if (this.isSetBitmapFilterNotIn()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bitmap_filter_not_in:");
            sb.append(this.bitmap_filter_not_in);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.src_expr == null) {
            throw new TProtocolException("Required field 'src_expr' was not present! Struct: " + this.toString());
        }
        if (this.planId_to_target_expr == null) {
            throw new TProtocolException("Required field 'planId_to_target_expr' was not present! Struct: " + this.toString());
        }
        if (this.type == null) {
            throw new TProtocolException("Required field 'type' was not present! Struct: " + this.toString());
        }
        if (this.src_expr != null) {
            this.src_expr.validate();
        }
        if (this.bitmap_target_expr != null) {
            this.bitmap_target_expr.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.FILTER_ID, new FieldMetaData("filter_id", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SRC_EXPR, new FieldMetaData("src_expr", 1, (FieldValueMetaData)new StructMetaData(12, TExpr.class)));
        tmpMap.put(_Fields.EXPR_ORDER, new FieldMetaData("expr_order", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.PLAN_ID_TO_TARGET_EXPR, new FieldMetaData("planId_to_target_expr", 1, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(8, "TPlanNodeId"), (FieldValueMetaData)new StructMetaData(12, TExpr.class))));
        tmpMap.put(_Fields.IS_BROADCAST_JOIN, new FieldMetaData("is_broadcast_join", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.HAS_LOCAL_TARGETS, new FieldMetaData("has_local_targets", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.HAS_REMOTE_TARGETS, new FieldMetaData("has_remote_targets", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, (FieldValueMetaData)new EnumMetaData(16, TRuntimeFilterType.class)));
        tmpMap.put(_Fields.BLOOM_FILTER_SIZE_BYTES, new FieldMetaData("bloom_filter_size_bytes", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.BITMAP_TARGET_EXPR, new FieldMetaData("bitmap_target_expr", 2, (FieldValueMetaData)new StructMetaData(12, TExpr.class)));
        tmpMap.put(_Fields.BITMAP_FILTER_NOT_IN, new FieldMetaData("bitmap_filter_not_in", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TRuntimeFilterDesc.class, metaDataMap);
    }

    private static class TRuntimeFilterDescTupleScheme
    extends TupleScheme<TRuntimeFilterDesc> {
        private TRuntimeFilterDescTupleScheme() {
        }

        public void write(TProtocol prot, TRuntimeFilterDesc struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.filter_id);
            struct.src_expr.write((TProtocol)oprot);
            oprot.writeI32(struct.expr_order);
            oprot.writeI32(struct.planId_to_target_expr.size());
            for (Map.Entry<Integer, TExpr> _iter781 : struct.planId_to_target_expr.entrySet()) {
                oprot.writeI32(_iter781.getKey().intValue());
                _iter781.getValue().write((TProtocol)oprot);
            }
            oprot.writeBool(struct.is_broadcast_join);
            oprot.writeBool(struct.has_local_targets);
            oprot.writeBool(struct.has_remote_targets);
            oprot.writeI32(struct.type.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetBloomFilterSizeBytes()) {
                optionals.set(0);
            }
            if (struct.isSetBitmapTargetExpr()) {
                optionals.set(1);
            }
            if (struct.isSetBitmapFilterNotIn()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetBloomFilterSizeBytes()) {
                oprot.writeI64(struct.bloom_filter_size_bytes);
            }
            if (struct.isSetBitmapTargetExpr()) {
                struct.bitmap_target_expr.write((TProtocol)oprot);
            }
            if (struct.isSetBitmapFilterNotIn()) {
                oprot.writeBool(struct.bitmap_filter_not_in);
            }
        }

        public void read(TProtocol prot, TRuntimeFilterDesc struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.filter_id = iprot.readI32();
            struct.setFilterIdIsSet(true);
            struct.src_expr = new TExpr();
            struct.src_expr.read((TProtocol)iprot);
            struct.setSrcExprIsSet(true);
            struct.expr_order = iprot.readI32();
            struct.setExprOrderIsSet(true);
            TMap _map782 = new TMap(8, 12, iprot.readI32());
            struct.planId_to_target_expr = new HashMap<Integer, TExpr>(2 * _map782.size);
            for (int _i785 = 0; _i785 < _map782.size; ++_i785) {
                int _key783 = iprot.readI32();
                TExpr _val784 = new TExpr();
                _val784.read((TProtocol)iprot);
                struct.planId_to_target_expr.put(_key783, _val784);
            }
            struct.setPlanIdToTargetExprIsSet(true);
            struct.is_broadcast_join = iprot.readBool();
            struct.setIsBroadcastJoinIsSet(true);
            struct.has_local_targets = iprot.readBool();
            struct.setHasLocalTargetsIsSet(true);
            struct.has_remote_targets = iprot.readBool();
            struct.setHasRemoteTargetsIsSet(true);
            struct.type = TRuntimeFilterType.findByValue(iprot.readI32());
            struct.setTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.bloom_filter_size_bytes = iprot.readI64();
                struct.setBloomFilterSizeBytesIsSet(true);
            }
            if (incoming.get(1)) {
                struct.bitmap_target_expr = new TExpr();
                struct.bitmap_target_expr.read((TProtocol)iprot);
                struct.setBitmapTargetExprIsSet(true);
            }
            if (incoming.get(2)) {
                struct.bitmap_filter_not_in = iprot.readBool();
                struct.setBitmapFilterNotInIsSet(true);
            }
        }
    }

    private static class TRuntimeFilterDescTupleSchemeFactory
    implements SchemeFactory {
        private TRuntimeFilterDescTupleSchemeFactory() {
        }

        public TRuntimeFilterDescTupleScheme getScheme() {
            return new TRuntimeFilterDescTupleScheme();
        }
    }

    private static class TRuntimeFilterDescStandardScheme
    extends StandardScheme<TRuntimeFilterDesc> {
        private TRuntimeFilterDescStandardScheme() {
        }

        public void read(TProtocol iprot, TRuntimeFilterDesc struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.filter_id = iprot.readI32();
                            struct.setFilterIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.src_expr = new TExpr();
                            struct.src_expr.read(iprot);
                            struct.setSrcExprIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.expr_order = iprot.readI32();
                            struct.setExprOrderIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 13) {
                            TMap _map776 = iprot.readMapBegin();
                            struct.planId_to_target_expr = new HashMap<Integer, TExpr>(2 * _map776.size);
                            for (int _i779 = 0; _i779 < _map776.size; ++_i779) {
                                int _key777 = iprot.readI32();
                                TExpr _val778 = new TExpr();
                                _val778.read(iprot);
                                struct.planId_to_target_expr.put(_key777, _val778);
                            }
                            iprot.readMapEnd();
                            struct.setPlanIdToTargetExprIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 2) {
                            struct.is_broadcast_join = iprot.readBool();
                            struct.setIsBroadcastJoinIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 2) {
                            struct.has_local_targets = iprot.readBool();
                            struct.setHasLocalTargetsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 2) {
                            struct.has_remote_targets = iprot.readBool();
                            struct.setHasRemoteTargetsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.type = TRuntimeFilterType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.bloom_filter_size_bytes = iprot.readI64();
                            struct.setBloomFilterSizeBytesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 12) {
                            struct.bitmap_target_expr = new TExpr();
                            struct.bitmap_target_expr.read(iprot);
                            struct.setBitmapTargetExprIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 2) {
                            struct.bitmap_filter_not_in = iprot.readBool();
                            struct.setBitmapFilterNotInIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetFilterId()) {
                throw new TProtocolException("Required field 'filter_id' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetExprOrder()) {
                throw new TProtocolException("Required field 'expr_order' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetIsBroadcastJoin()) {
                throw new TProtocolException("Required field 'is_broadcast_join' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetHasLocalTargets()) {
                throw new TProtocolException("Required field 'has_local_targets' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetHasRemoteTargets()) {
                throw new TProtocolException("Required field 'has_remote_targets' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TRuntimeFilterDesc struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(FILTER_ID_FIELD_DESC);
            oprot.writeI32(struct.filter_id);
            oprot.writeFieldEnd();
            if (struct.src_expr != null) {
                oprot.writeFieldBegin(SRC_EXPR_FIELD_DESC);
                struct.src_expr.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(EXPR_ORDER_FIELD_DESC);
            oprot.writeI32(struct.expr_order);
            oprot.writeFieldEnd();
            if (struct.planId_to_target_expr != null) {
                oprot.writeFieldBegin(PLAN_ID_TO_TARGET_EXPR_FIELD_DESC);
                oprot.writeMapBegin(new TMap(8, 12, struct.planId_to_target_expr.size()));
                for (Map.Entry<Integer, TExpr> _iter780 : struct.planId_to_target_expr.entrySet()) {
                    oprot.writeI32(_iter780.getKey().intValue());
                    _iter780.getValue().write(oprot);
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(IS_BROADCAST_JOIN_FIELD_DESC);
            oprot.writeBool(struct.is_broadcast_join);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(HAS_LOCAL_TARGETS_FIELD_DESC);
            oprot.writeBool(struct.has_local_targets);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(HAS_REMOTE_TARGETS_FIELD_DESC);
            oprot.writeBool(struct.has_remote_targets);
            oprot.writeFieldEnd();
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.isSetBloomFilterSizeBytes()) {
                oprot.writeFieldBegin(BLOOM_FILTER_SIZE_BYTES_FIELD_DESC);
                oprot.writeI64(struct.bloom_filter_size_bytes);
                oprot.writeFieldEnd();
            }
            if (struct.bitmap_target_expr != null && struct.isSetBitmapTargetExpr()) {
                oprot.writeFieldBegin(BITMAP_TARGET_EXPR_FIELD_DESC);
                struct.bitmap_target_expr.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetBitmapFilterNotIn()) {
                oprot.writeFieldBegin(BITMAP_FILTER_NOT_IN_FIELD_DESC);
                oprot.writeBool(struct.bitmap_filter_not_in);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TRuntimeFilterDescStandardSchemeFactory
    implements SchemeFactory {
        private TRuntimeFilterDescStandardSchemeFactory() {
        }

        public TRuntimeFilterDescStandardScheme getScheme() {
            return new TRuntimeFilterDescStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        FILTER_ID(1, "filter_id"),
        SRC_EXPR(2, "src_expr"),
        EXPR_ORDER(3, "expr_order"),
        PLAN_ID_TO_TARGET_EXPR(4, "planId_to_target_expr"),
        IS_BROADCAST_JOIN(5, "is_broadcast_join"),
        HAS_LOCAL_TARGETS(6, "has_local_targets"),
        HAS_REMOTE_TARGETS(7, "has_remote_targets"),
        TYPE(8, "type"),
        BLOOM_FILTER_SIZE_BYTES(9, "bloom_filter_size_bytes"),
        BITMAP_TARGET_EXPR(10, "bitmap_target_expr"),
        BITMAP_FILTER_NOT_IN(11, "bitmap_filter_not_in");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return FILTER_ID;
                }
                case 2: {
                    return SRC_EXPR;
                }
                case 3: {
                    return EXPR_ORDER;
                }
                case 4: {
                    return PLAN_ID_TO_TARGET_EXPR;
                }
                case 5: {
                    return IS_BROADCAST_JOIN;
                }
                case 6: {
                    return HAS_LOCAL_TARGETS;
                }
                case 7: {
                    return HAS_REMOTE_TARGETS;
                }
                case 8: {
                    return TYPE;
                }
                case 9: {
                    return BLOOM_FILTER_SIZE_BYTES;
                }
                case 10: {
                    return BITMAP_TARGET_EXPR;
                }
                case 11: {
                    return BITMAP_FILTER_NOT_IN;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

