/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.meta;

public class MetaContext {
    private int metaVersion;
    private static ThreadLocal<MetaContext> threadLocalInfo = new ThreadLocal();

    public void setMetaVersion(int metaVersion) {
        if (metaVersion < 100) {
            throw new IllegalArgumentException("Could not set meta version to " + metaVersion + " since it is lower than minimum required version " + 100);
        }
        this.metaVersion = metaVersion;
    }

    public int getMetaVersion() {
        return this.metaVersion;
    }

    public void setThreadLocalInfo() {
        threadLocalInfo.set(this);
    }

    public static MetaContext get() {
        return threadLocalInfo.get();
    }

    public static void remove() {
        threadLocalInfo.remove();
    }
}

