/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.property;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.property.PropertySchema;
import org.apache.doris.thrift.TPropertyVal;

public class PropertiesSet<T extends PropertySchema.SchemaGroup> {
    private static final Map<PropertySchema.SchemaGroup, PropertiesSet> emptyInstances = new HashMap<PropertySchema.SchemaGroup, PropertiesSet>();
    private final T schemaGroup;
    private final Map<String, Object> properties;
    private List<PropertySchema> modifiedSchemas;

    private PropertiesSet(T schemaGroup, Map<String, Object> properties) {
        this.schemaGroup = schemaGroup;
        this.properties = properties;
    }

    public <U> U get(PropertySchema<U> prop) throws NoSuchElementException {
        return (U)(this.properties.containsKey(prop.getName()) ? this.properties.get(prop.getName()) : prop.getDefaultValue().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertySchema> getModifiedSchemas() {
        if (this.modifiedSchemas == null) {
            PropertiesSet propertiesSet = this;
            synchronized (propertiesSet) {
                this.modifiedSchemas = this.properties.keySet().stream().map(key -> (PropertySchema)this.schemaGroup.getSchemas().get(key)).collect(Collectors.toList());
            }
        }
        return this.modifiedSchemas;
    }

    private static <TSchemaGroup extends PropertySchema.SchemaGroup, TRaw> void checkRequiredKey(TSchemaGroup schemaGroup, Map<String, TRaw> rawProperties) throws NoSuchElementException {
        List requiredKey = schemaGroup.getSchemas().values().stream().filter(propertySchema -> !propertySchema.getDefaultValue().isPresent()).map(PropertySchema::getName).collect(Collectors.toList());
        List missingKeys = requiredKey.stream().filter(key -> !rawProperties.containsKey(key)).collect(Collectors.toList());
        if (!missingKeys.isEmpty()) {
            throw new NoSuchElementException("Missing " + missingKeys);
        }
    }

    public static <TSchemaGroup extends PropertySchema.SchemaGroup> void verifyKey(TSchemaGroup schemaGroup, List<String> rawProperties) throws IllegalArgumentException {
        rawProperties.forEach(entry -> {
            if (!schemaGroup.getSchemas().containsKey((Object)entry.toLowerCase())) {
                throw new IllegalArgumentException("Invalid property " + entry);
            }
        });
    }

    public Map<String, TPropertyVal> writeToThrift() {
        HashMap<String, TPropertyVal> ret = new HashMap<String, TPropertyVal>(this.properties.size());
        this.properties.forEach((key, value) -> {
            TPropertyVal out = new TPropertyVal();
            ((PropertySchema)this.schemaGroup.getSchemas().get(key)).write(value, out);
            ret.put((String)key, out);
        });
        return ret;
    }

    public void writeToData(DataOutput out) throws IOException {
        out.writeInt(this.properties.size());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Text.writeString(out, entry.getKey());
            ((PropertySchema)this.schemaGroup.getSchemas().get((Object)entry.getKey())).write(entry.getValue(), out);
        }
    }

    private static <TSchemaGroup extends PropertySchema.SchemaGroup, TParsed, TRaw> PropertiesSet<TSchemaGroup> read(TSchemaGroup schemaGroup, Map<String, TRaw> rawProperties, ReadLambda<TParsed, TRaw> reader) throws IllegalArgumentException, NoSuchElementException {
        PropertiesSet.checkRequiredKey(schemaGroup, rawProperties);
        HashMap<String, Object> properties = new HashMap<String, Object>(rawProperties.size());
        rawProperties.forEach((key, value) -> {
            String entryKey = key.toLowerCase();
            if (!schemaGroup.getSchemas().containsKey((Object)entryKey)) {
                throw new IllegalArgumentException("Invalid property " + key);
            }
            PropertySchema schema = (PropertySchema)schemaGroup.getSchemas().get((Object)entryKey);
            properties.put(entryKey, reader.accept(schema, value));
        });
        return new PropertiesSet<TSchemaGroup>(schemaGroup, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <TSchemaGroup extends PropertySchema.SchemaGroup> PropertiesSet<TSchemaGroup> empty(TSchemaGroup schemaGroup) {
        if (emptyInstances.containsKey(schemaGroup)) return emptyInstances.get(schemaGroup);
        Class<PropertiesSet> clazz = PropertiesSet.class;
        synchronized (PropertiesSet.class) {
            if (emptyInstances.containsKey(schemaGroup)) return emptyInstances.get(schemaGroup);
            emptyInstances.put(schemaGroup, new PropertiesSet<TSchemaGroup>(schemaGroup, Collections.emptyMap()));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return emptyInstances.get(schemaGroup);
        }
    }

    public static <TSchemaGroup extends PropertySchema.SchemaGroup> PropertiesSet<TSchemaGroup> readFromStrMap(TSchemaGroup schemaGroup, Map<String, String> rawProperties) throws IllegalArgumentException {
        return PropertiesSet.read(schemaGroup, rawProperties, PropertySchema::read);
    }

    public static <TSchemaGroup extends PropertySchema.SchemaGroup> PropertiesSet<TSchemaGroup> readFromThrift(TSchemaGroup schemaGroup, Map<String, TPropertyVal> rawProperties) throws IllegalArgumentException {
        return PropertiesSet.read(schemaGroup, rawProperties, PropertySchema::read);
    }

    public static <TSchemaGroup extends PropertySchema.SchemaGroup> PropertiesSet<TSchemaGroup> readFromData(TSchemaGroup schemaGroup, DataInput input) throws IllegalArgumentException, IOException {
        int size = input.readInt();
        HashMap<String, Object> properties = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            String key = Text.readString(input).toLowerCase();
            Object val = ((PropertySchema)schemaGroup.getSchemas().get((Object)key)).read(input);
            properties.put(key, val);
        }
        return new PropertiesSet<TSchemaGroup>(schemaGroup, properties);
    }

    public String toString() {
        return this.properties.toString();
    }

    private static interface ReadLambda<TParsed, TRaw> {
        public TParsed accept(PropertySchema var1, TRaw var2);
    }
}

