/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.jmockit;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.doris.common.jmockit.AutoType;
import org.apache.doris.common.jmockit.ParameterReflection;
import org.apache.doris.common.jmockit.ThrowOfCheckedException;

public final class MethodReflection {
    private MethodReflection() {
    }

    public static <T> T invoke(Class<?> theClass, Object targetInstance, String methodName, Object ... methodArgs) {
        Method method;
        if (theClass == null || methodName == null) {
            throw new IllegalArgumentException();
        }
        boolean staticMethod = targetInstance == null;
        Class<?>[] argTypes = ParameterReflection.getArgumentTypesFromArgumentValues(methodArgs);
        Method method2 = method = staticMethod ? MethodReflection.findCompatibleStaticMethod(theClass, methodName, argTypes) : MethodReflection.findCompatibleMethod(theClass, methodName, argTypes);
        if (staticMethod && !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Attempted to invoke non-static method without an instance to invoke it on");
        }
        T result = MethodReflection.invoke(targetInstance, method, methodArgs);
        return result;
    }

    public static <T> T invoke(Object targetInstance, Method method, Object ... methodArgs) {
        if (method == null || methodArgs == null) {
            throw new IllegalArgumentException();
        }
        MethodReflection.makeAccessible(method);
        try {
            return (T)method.invoke(targetInstance, methodArgs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failure to invoke method: " + method, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            ThrowOfCheckedException.doThrow((Exception)cause);
            return null;
        }
    }

    private static Method findCompatibleStaticMethod(Class<?> theClass, String methodName, Class<?>[] argTypes) {
        if (theClass == null || methodName == null || argTypes == null) {
            throw new IllegalArgumentException();
        }
        Method methodFound = MethodReflection.findCompatibleMethodInClass(theClass, methodName, argTypes);
        if (methodFound != null) {
            return methodFound;
        }
        String argTypesDesc = ParameterReflection.getParameterTypesDescription(argTypes);
        throw new IllegalArgumentException("No compatible static method found: " + methodName + argTypesDesc);
    }

    public static Method findCompatibleMethod(Class<?> theClass, String methodName, Class<?>[] argTypes) {
        if (theClass == null || methodName == null || argTypes == null) {
            throw new IllegalArgumentException();
        }
        Method methodFound = MethodReflection.findCompatibleMethodIfAvailable(theClass, methodName, argTypes);
        if (methodFound != null) {
            return methodFound;
        }
        String argTypesDesc = ParameterReflection.getParameterTypesDescription(argTypes);
        throw new IllegalArgumentException("No compatible method found: " + methodName + argTypesDesc);
    }

    private static Method findCompatibleMethodInClass(Class<?> theClass, String methodName, Class<?>[] argTypes) {
        Method[] methods;
        if (theClass == null || methodName == null || argTypes == null) {
            throw new IllegalArgumentException();
        }
        Method found = null;
        Class<?>[] foundParamTypes = null;
        for (Method declaredMethod : methods = theClass.getDeclaredMethods()) {
            Class<?>[] declaredParamTypes;
            int gap;
            if (!declaredMethod.getName().equals(methodName) || (gap = (declaredParamTypes = declaredMethod.getParameterTypes()).length - argTypes.length) != 0 || !ParameterReflection.matchesParameterTypes(declaredParamTypes, argTypes) && !ParameterReflection.acceptsArgumentTypes(declaredParamTypes, argTypes) || foundParamTypes != null && !ParameterReflection.hasMoreSpecificTypes(declaredParamTypes, foundParamTypes)) continue;
            found = declaredMethod;
            foundParamTypes = declaredParamTypes;
        }
        return found;
    }

    private static Method findCompatibleMethodIfAvailable(Class<?> theClass, String methodName, Class<?>[] argTypes) {
        if (theClass == null || methodName == null || argTypes == null) {
            throw new IllegalArgumentException();
        }
        Method methodFound = null;
        while (true) {
            Class<?> superClass;
            Method compatibleMethod;
            if ((compatibleMethod = MethodReflection.findCompatibleMethodInClass(theClass, methodName, argTypes)) != null && (methodFound == null || ParameterReflection.hasMoreSpecificTypes(compatibleMethod.getParameterTypes(), methodFound.getParameterTypes()))) {
                methodFound = compatibleMethod;
            }
            if ((superClass = theClass.getSuperclass()) == null || superClass == Object.class) {
                return methodFound;
            }
            theClass = superClass;
        }
    }

    public static void makeAccessible(AccessibleObject classMember) {
        if (!classMember.isAccessible()) {
            classMember.setAccessible(true);
        }
    }

    private static boolean isSameType(Class<?> firstType, Class<?> secondType) {
        return firstType == secondType || firstType.isPrimitive() && firstType == AutoType.getPrimitiveType(secondType) || secondType.isPrimitive() && secondType == AutoType.getPrimitiveType(firstType);
    }
}

