/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.jmockit;

import java.lang.reflect.Proxy;

public final class GeneratedClasses {
    private static final String IMPLCLASS_PREFIX = "$Impl_";
    private static final String SUBCLASS_PREFIX = "$Subclass_";

    private GeneratedClasses() {
    }

    static boolean isGeneratedImplementationClass(Class<?> mockedType) {
        return GeneratedClasses.isGeneratedImplementationClass(mockedType.getName());
    }

    static boolean isGeneratedImplementationClass(String className) {
        return className.contains(IMPLCLASS_PREFIX);
    }

    static boolean isGeneratedSubclass(String className) {
        return className.contains(SUBCLASS_PREFIX);
    }

    static boolean isGeneratedClass(String className) {
        return GeneratedClasses.isGeneratedSubclass(className) || GeneratedClasses.isGeneratedImplementationClass(className);
    }

    static Class<?> getMockedClassOrInterfaceType(Class<?> aClass) {
        if (!Proxy.isProxyClass(aClass) && !GeneratedClasses.isGeneratedImplementationClass(aClass)) {
            return GeneratedClasses.isGeneratedSubclass(aClass.getName()) ? aClass.getSuperclass() : aClass;
        }
        return aClass.getInterfaces()[0];
    }

    static Class<?> getMockedClass(Object mock) {
        return GeneratedClasses.getMockedClassOrInterfaceType(mock.getClass());
    }
}

