/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.jmockit;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.doris.common.jmockit.AutoType;

public final class FieldReflection {
    private FieldReflection() {
    }

    public static <T> T getField(Class<?> theClass, String fieldName, Object targetObject) {
        if (theClass == null || fieldName == null || targetObject == null) {
            throw new IllegalStateException();
        }
        Field field = FieldReflection.getDeclaredField(theClass, fieldName, targetObject != null);
        return FieldReflection.getFieldValue(field, targetObject);
    }

    public static <T> T getField(Class<?> theClass, Class<T> fieldType, Object targetObject) {
        if (theClass == null || fieldType == null) {
            throw new IllegalStateException();
        }
        Field field = FieldReflection.getDeclaredField(theClass, fieldType, targetObject != null, false);
        return FieldReflection.getFieldValue(field, targetObject);
    }

    public static <T> T getField(Class<?> theClass, Type fieldType, Object targetObject) {
        if (theClass == null || fieldType == null) {
            throw new IllegalStateException();
        }
        Field field = FieldReflection.getDeclaredField(theClass, fieldType, targetObject != null, false);
        return FieldReflection.getFieldValue(field, targetObject);
    }

    public static Field setField(Class<?> theClass, Object targetObject, String fieldName, Object fieldValue) {
        Field field;
        boolean instanceField;
        if (theClass == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = instanceField = targetObject != null;
        if (fieldName != null) {
            field = FieldReflection.getDeclaredField(theClass, fieldName, instanceField);
        } else {
            if (fieldValue == null) {
                throw new IllegalArgumentException("Missing field value when setting field by type");
            }
            field = FieldReflection.getDeclaredField(theClass, fieldValue.getClass(), instanceField, true);
        }
        FieldReflection.setFieldValue(field, targetObject, fieldValue);
        return field;
    }

    private static Field getDeclaredField(Class<?> theClass, String fieldName, boolean instanceField) {
        if (theClass == null || fieldName == null) {
            throw new IllegalStateException();
        }
        try {
            return theClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = theClass.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                return FieldReflection.getDeclaredField(superClass, fieldName, instanceField);
            }
            String kind = instanceField ? "instance" : "static";
            throw new IllegalArgumentException("No " + kind + " field of name \"" + fieldName + "\" found in " + theClass);
        }
    }

    private static Field getDeclaredField(Class<?> theClass, Type desiredType, boolean instanceField, boolean forAssignment) {
        if (theClass == null || desiredType == null) {
            throw new IllegalStateException();
        }
        Field found = FieldReflection.getDeclaredFieldInSingleClass(theClass, desiredType, instanceField, forAssignment);
        if (found == null) {
            Class<?> superClass = theClass.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                return FieldReflection.getDeclaredField(superClass, desiredType, instanceField, forAssignment);
            }
            StringBuilder errorMsg = new StringBuilder(instanceField ? "Instance" : "Static");
            String typeName = FieldReflection.getTypeName(desiredType);
            errorMsg.append(" field of type ").append(typeName).append(" not found in ").append(theClass);
            throw new IllegalArgumentException(errorMsg.toString());
        }
        return found;
    }

    private static Field getDeclaredFieldInSingleClass(Class<?> theClass, Type desiredType, boolean instanceField, boolean forAssignment) {
        Field[] fields;
        if (theClass == null || desiredType == null) {
            throw new IllegalStateException();
        }
        Field found = null;
        for (Field field : fields = theClass.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            Type fieldType = field.getGenericType();
            if (instanceField == Modifier.isStatic(field.getModifiers()) || !FieldReflection.isCompatibleFieldType(fieldType, desiredType, forAssignment)) continue;
            if (found != null) {
                String message = FieldReflection.errorMessageForMoreThanOneFieldFound(desiredType, instanceField, forAssignment, found, field);
                throw new IllegalArgumentException(message);
            }
            found = field;
        }
        return found;
    }

    private static boolean isCompatibleFieldType(Type fieldType, Type desiredType, boolean forAssignment) {
        if (fieldType == null || desiredType == null) {
            throw new IllegalStateException();
        }
        Class<?> fieldClass = FieldReflection.getClassType(fieldType);
        Class<?> desiredClass = FieldReflection.getClassType(desiredType);
        if (FieldReflection.isSameType(desiredClass, fieldClass)) {
            return true;
        }
        if (forAssignment) {
            return fieldClass.isAssignableFrom(desiredClass);
        }
        return desiredClass.isAssignableFrom(fieldClass) || fieldClass.isAssignableFrom(desiredClass);
    }

    private static String errorMessageForMoreThanOneFieldFound(Type desiredFieldType, boolean instanceField, boolean forAssignment, Field firstField, Field secondField) {
        return "More than one " + (instanceField ? "instance" : "static") + " field " + (forAssignment ? "to" : "from") + " which a value of type " + FieldReflection.getTypeName(desiredFieldType) + (forAssignment ? " can be assigned" : " can be read") + " exists in " + secondField.getDeclaringClass() + ": " + firstField.getName() + ", " + secondField.getName();
    }

    private static String getTypeName(Type type) {
        if (type == null) {
            throw new IllegalStateException();
        }
        Class<?> classType = FieldReflection.getClassType(type);
        Class<?> primitiveType = AutoType.getPrimitiveType(classType);
        if (primitiveType != null) {
            return primitiveType + " or " + classType.getSimpleName();
        }
        String name = classType.getName();
        return name.startsWith("java.lang.") ? name.substring(10) : name;
    }

    private static <T> T getFieldValue(Field field, Object targetObject) {
        if (field == null) {
            throw new IllegalStateException();
        }
        FieldReflection.makeAccessible(field);
        try {
            return (T)field.get(targetObject);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Field field, Object targetObject, Object value) {
        if (field == null) {
            throw new IllegalStateException();
        }
        try {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                throw new IllegalArgumentException("Do not allow to set static final field");
            }
            FieldReflection.makeAccessible(field);
            field.set(targetObject, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getClassType(Type declaredType) {
        while (!(declaredType instanceof Class)) {
            if (declaredType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)declaredType).getRawType();
            }
            if (!(declaredType instanceof TypeVariable)) {
                throw new IllegalArgumentException("Type of unexpected kind: " + declaredType);
            }
            declaredType = ((TypeVariable)declaredType).getBounds()[0];
        }
        return (Class)declaredType;
    }

    public static void makeAccessible(AccessibleObject classMember) {
        if (!classMember.isAccessible()) {
            classMember.setAccessible(true);
        }
    }

    private static boolean isSameType(Class<?> firstType, Class<?> secondType) {
        return firstType == secondType || firstType.isPrimitive() && firstType == AutoType.getPrimitiveType(secondType) || secondType.isPrimitive() && secondType == AutoType.getPrimitiveType(firstType);
    }
}

