/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingDataOutputStream
extends DataOutputStream {
    public CountingDataOutputStream(OutputStream out) {
        super(new CountingOutputStream(out, 0L));
    }

    public CountingDataOutputStream(OutputStream out, long count) {
        super(new CountingOutputStream(out, count));
    }

    public long getCount() {
        return ((CountingOutputStream)this.out).getCount();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private long count;

        public CountingOutputStream(OutputStream out, long count) {
            super(out);
            this.count = count;
        }

        public long getCount() {
            return this.count;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.count += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.count;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

