/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.model.BaseHeartBeat;
import org.apache.dolphinscheduler.common.model.BaseHeartBeatTask;
import org.apache.dolphinscheduler.common.model.WorkerHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.utils.RegistryUtils;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.config.WorkerServerLoadProtection;
import org.apache.dolphinscheduler.server.worker.metrics.WorkerServerMetrics;
import org.apache.dolphinscheduler.task.executor.container.ITaskExecutorContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerHeartBeatTask
extends BaseHeartBeatTask<WorkerHeartBeat> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerHeartBeatTask.class);
    private final WorkerConfig workerConfig;
    private final WorkerServerLoadProtection workerServerLoadProtection;
    private final RegistryClient registryClient;
    private final MetricsProvider metricsProvider;
    private final int processId;
    private final ITaskExecutorContainer taskExecutorContainer;

    public WorkerHeartBeatTask(@NonNull WorkerConfig workerConfig, @NonNull WorkerServerLoadProtection workerServerLoadProtection, @NonNull MetricsProvider metricsProvider, @NonNull RegistryClient registryClient, @NonNull ITaskExecutorContainer taskExecutorContainer) {
        super("WorkerHeartBeatTask", workerConfig.getMaxHeartbeatInterval().toMillis());
        if (workerConfig == null) {
            throw new NullPointerException("workerConfig is marked non-null but is null");
        }
        if (workerServerLoadProtection == null) {
            throw new NullPointerException("workerServerLoadProtection is marked non-null but is null");
        }
        if (metricsProvider == null) {
            throw new NullPointerException("metricsProvider is marked non-null but is null");
        }
        if (registryClient == null) {
            throw new NullPointerException("registryClient is marked non-null but is null");
        }
        if (taskExecutorContainer == null) {
            throw new NullPointerException("taskExecutorContainer is marked non-null but is null");
        }
        this.workerServerLoadProtection = workerServerLoadProtection;
        this.metricsProvider = metricsProvider;
        this.workerConfig = workerConfig;
        this.registryClient = registryClient;
        this.taskExecutorContainer = taskExecutorContainer;
        this.processId = OSUtils.getProcessID();
    }

    public WorkerHeartBeat getHeartBeat() {
        SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
        return ((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)((WorkerHeartBeat.WorkerHeartBeatBuilder)WorkerHeartBeat.builder().startupTime(ServerLifeCycleManager.getServerStartupTime())).reportTime(System.currentTimeMillis())).jvmCpuUsage(systemMetrics.getJvmCpuUsagePercentage())).cpuUsage(systemMetrics.getSystemCpuUsagePercentage())).jvmMemoryUsage(systemMetrics.getJvmMemoryUsedPercentage())).jvmHeapUsed(systemMetrics.getJvmHeapUsed())).jvmHeapMax(systemMetrics.getJvmHeapMax())).jvmNonHeapUsed(systemMetrics.getJvmNonHeapUsed())).jvmNonHeapMax(systemMetrics.getJvmNonHeapMax())).memoryUsage(systemMetrics.getSystemMemoryUsedPercentage())).diskUsage(systemMetrics.getDiskUsedPercentage())).processId(this.processId)).workerHostWeight(this.workerConfig.getHostWeight()).threadPoolUsage(this.taskExecutorContainer.slotUsage()).serverStatus(this.workerServerLoadProtection.isOverload(systemMetrics) ? ServerStatus.BUSY : ServerStatus.NORMAL)).host(NetUtils.getHost())).port(this.workerConfig.getListenPort())).workerGroup(this.workerConfig.getGroup()).build();
    }

    public void writeHeartBeat(WorkerHeartBeat workerHeartBeat) {
        String failoverNodePath = RegistryUtils.getFailoveredNodePath((BaseHeartBeat)workerHeartBeat);
        if (this.registryClient.exists(failoverNodePath)) {
            log.warn("The worker: {} is under {}, means it has been failover will close myself", (Object)workerHeartBeat, (Object)failoverNodePath);
            this.registryClient.getStoppable().stop("The worker exist: " + failoverNodePath + ", means it has been failover will close myself");
            return;
        }
        String workerHeartBeatJson = JSONUtils.toJsonString((Object)workerHeartBeat);
        String workerRegistryPath = this.workerConfig.getWorkerRegistryPath();
        this.registryClient.persistEphemeral(workerRegistryPath, workerHeartBeatJson);
        WorkerServerMetrics.incWorkerHeartbeatCount();
        log.debug("Success write worker group heartBeatInfo into registry, workerRegistryPath: {} workerHeartBeatInfo: {}", (Object)workerRegistryPath, (Object)workerHeartBeatJson);
    }
}

