/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.resource;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MigrateResourceService {
    private static final Logger logger = LoggerFactory.getLogger(MigrateResourceService.class);
    @Autowired
    private StorageOperator storageOperator;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private DataSource dataSource;
    private static final String MIGRATE_BASE_DIR = ".migrate";

    public void migrateResourceOnce(String targetTenantCode) throws SQLException {
        if (!this.tenantMapper.existTenant(targetTenantCode).booleanValue()) {
            logger.error("Tenant not exists!");
            return;
        }
        String resMigrateBasePath = this.createMigrateDirByType(targetTenantCode, ResourceType.FILE);
        if (StringUtils.isEmpty((CharSequence)resMigrateBasePath)) {
            return;
        }
        List<Map<String, Object>> resources = this.getAllResources();
        for (Map<String, Object> item : resources) {
            String oriFullName = (String)item.get("full_name");
            int type = (Integer)item.get("type");
            int id = (Integer)item.get("id");
            try {
                String string = oriFullName = oriFullName.startsWith("/") ? oriFullName.substring(1) : oriFullName;
                if (ResourceType.FILE.getCode() != type) continue;
                this.storageOperator.copy(oriFullName, String.format("%s/%s", resMigrateBasePath, oriFullName), true, true);
            }
            catch (Exception e) {
                logger.error("Migrate resource: {} failed: {}", item, (Object)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private List<Map<String, Object>> getAllResources() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String createMigrateDirByType(String targetTenantCode, ResourceType type) {
        String migrateBasePath = this.storageOperator.getStorageBaseDirectory(targetTenantCode, type);
        migrateBasePath = migrateBasePath + MIGRATE_BASE_DIR;
        try {
            this.storageOperator.createStorageDir(migrateBasePath);
        }
        catch (Exception e) {
            logger.error("create migrate base directory {} failed", (Object)migrateBasePath);
            return "";
        }
        return migrateBasePath;
    }
}

