/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop;

import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.log.SensitiveDataConverter;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.SqoopJobGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopTask
extends AbstractYarnTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqoopTask.class);
    private SqoopParameters sqoopParameters;
    private final TaskExecutionContext taskExecutionContext;
    private SqoopTaskExecutionContext sqoopTaskExecutionContext;

    public SqoopTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.sqoopParameters = (SqoopParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), SqoopParameters.class));
        log.info("Initialize sqoop task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.sqoopParameters)));
        if (null == this.sqoopParameters) {
            throw new TaskException("Sqoop Task params is null");
        }
        if (!this.sqoopParameters.checkParameters()) {
            throw new TaskException("Sqoop Task params check fail");
        }
        this.sqoopTaskExecutionContext = this.sqoopParameters.generateExtendedContext(this.taskExecutionContext.getResourceParametersHelper());
        SensitiveDataConverter.addMaskPattern((String)"(?<=(--password \")).+?(?=\")");
    }

    protected String getScript() {
        SqoopJobGenerator generator = new SqoopJobGenerator();
        return generator.generateSqoopJob(this.sqoopParameters, this.sqoopTaskExecutionContext);
    }

    public AbstractParameters getParameters() {
        return this.sqoopParameters;
    }
}

