/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.seatunnel;

import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannel;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.seatunnel.SeatunnelParameters;
import org.apache.dolphinscheduler.plugin.task.seatunnel.SeatunnelTask;
import org.apache.dolphinscheduler.plugin.task.seatunnel.flink.SeatunnelFlinkTask;
import org.apache.dolphinscheduler.plugin.task.seatunnel.self.SeatunnelEngineTask;
import org.apache.dolphinscheduler.plugin.task.seatunnel.spark.SeatunnelSparkTask;

public class SeatunnelTaskChannel
implements TaskChannel {
    public SeatunnelTask createTask(TaskExecutionContext taskRequest) {
        SeatunnelParameters seatunnelParameters = (SeatunnelParameters)((Object)JSONUtils.parseObject((String)taskRequest.getTaskParams(), SeatunnelParameters.class));
        assert (seatunnelParameters != null);
        String startupScript = seatunnelParameters.getStartupScript();
        if (startupScript.contains("spark")) {
            return new SeatunnelSparkTask(taskRequest);
        }
        if (startupScript.contains("flink")) {
            return new SeatunnelFlinkTask(taskRequest);
        }
        if (startupScript.contains("seatunnel")) {
            return new SeatunnelEngineTask(taskRequest);
        }
        throw new IllegalArgumentException("Unsupported startup script name:" + seatunnelParameters.getStartupScript());
    }

    public AbstractParameters parseParameters(String taskParams) {
        return (AbstractParameters)JSONUtils.parseObject((String)taskParams, SeatunnelParameters.class);
    }
}

