/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.seatunnel;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.resource.ResourceContext;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.shell.ShellInterceptorBuilderFactory;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.seatunnel.SeatunnelParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeatunnelTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SeatunnelTask.class);
    private static final String SEATUNNEL_BIN_DIR = "${SEATUNNEL_HOME}/bin/";
    private SeatunnelParameters seatunnelParameters;
    private ShellCommandExecutor shellCommandExecutor;
    protected final TaskExecutionContext taskExecutionContext;

    public SeatunnelTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((SeatunnelTask)this).logHandle(arg_0), taskExecutionContext);
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        log.info("Intialize SeaTunnel task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.seatunnelParameters)));
        if (this.seatunnelParameters == null || !this.seatunnelParameters.checkParameters()) {
            throw new TaskException("SeaTunnel task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            String command = this.buildCommand();
            IShellInterceptorBuilder shellActuatorBuilder = ShellInterceptorBuilderFactory.newBuilder().appendScript(command);
            TaskResponse commandExecuteResult = this.shellCommandExecutor.run(shellActuatorBuilder, taskCallBack);
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setAppIds(String.join((CharSequence)",", this.getApplicationIds()));
            this.setProcessId(commandExecuteResult.getProcessId());
            this.seatunnelParameters.dealOutParam(this.shellCommandExecutor.getTaskOutputParams());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("The current SeaTunnel task has been interrupted", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("The current SeaTunnel task has been interrupted", (Throwable)e);
        }
        catch (Exception e) {
            log.error("SeaTunnel task error", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("Execute Seatunnel task failed", (Throwable)e);
        }
    }

    public void submitApplication() throws TaskException {
    }

    public void trackApplicationStatus() throws TaskException {
    }

    public void cancelApplication() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    private String buildCommand() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add(SEATUNNEL_BIN_DIR + this.seatunnelParameters.getStartupScript());
        args.addAll(this.buildOptions());
        String command = String.join((CharSequence)" ", args);
        log.info("SeaTunnel task command: {}", (Object)command);
        return command;
    }

    protected List<String> buildOptions() throws Exception {
        String scriptContent;
        ArrayList<String> args = new ArrayList<String>();
        args.add("--config");
        if (BooleanUtils.isTrue((Boolean)this.seatunnelParameters.getUseCustom())) {
            scriptContent = this.buildCustomConfigContent();
        } else {
            String resourceFileName = this.seatunnelParameters.getResourceList().get(0).getResourceName();
            ResourceContext resourceContext = this.taskExecutionContext.getResourceContext();
            scriptContent = FileUtils.readFileToString((File)new File(resourceContext.getResourceItem(resourceFileName).getResourceAbsolutePathInLocal()), (Charset)StandardCharsets.UTF_8);
        }
        String filePath = this.buildConfigFilePath();
        this.createConfigFileIfNotExists(scriptContent, filePath);
        args.add(filePath);
        args.addAll(this.generateTaskParameters());
        return args;
    }

    private List<String> generateTaskParameters() {
        List localParams;
        HashMap<String, String> variables = new HashMap<String, String>();
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        List propertyList = JSONUtils.toList((String)this.taskExecutionContext.getGlobalParams(), Property.class);
        if (propertyList != null && !propertyList.isEmpty()) {
            for (Property property : propertyList) {
                variables.put(property.getProp(), ((Property)paramsMap.get(property.getProp())).getValue());
            }
        }
        if ((localParams = this.seatunnelParameters.getLocalParams()) != null && !localParams.isEmpty()) {
            for (Property property : localParams) {
                if (!property.getDirect().equals((Object)Direct.IN)) continue;
                variables.put(property.getProp(), ((Property)paramsMap.get(property.getProp())).getValue());
            }
        }
        ArrayList<String> parameters = new ArrayList<String>();
        variables.forEach((k, v) -> {
            parameters.add("-i");
            parameters.add(String.format("%s='%s'", k, v));
        });
        return parameters;
    }

    private String buildCustomConfigContent() {
        log.info("raw custom config content : {}", (Object)this.seatunnelParameters.getRawScript());
        String script = this.seatunnelParameters.getRawScript().replaceAll("\\r\\n", System.lineSeparator());
        script = this.parseScript(script);
        return script;
    }

    private String buildConfigFilePath() {
        return String.format("%s/seatunnel_%s.%s", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId(), this.formatDetector());
    }

    private String formatDetector() {
        return JSONUtils.checkJsonValid((String)this.seatunnelParameters.getRawScript(), (Boolean)false) ? "json" : "conf";
    }

    private void createConfigFileIfNotExists(String script, String scriptFile) throws IOException {
        log.info("tenantCode :{}, task dir:{}", (Object)this.taskExecutionContext.getTenantCode(), (Object)this.taskExecutionContext.getExecutePath());
        if (!Files.exists(Paths.get(scriptFile, new String[0]), new LinkOption[0])) {
            log.info("generate script file:{}", (Object)scriptFile);
            FileUtils.writeStringToFile((File)new File(scriptFile), (String)script, (Charset)StandardCharsets.UTF_8);
        }
    }

    public AbstractParameters getParameters() {
        return this.seatunnelParameters;
    }

    private String parseScript(String script) {
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        return ParameterUtils.convertParameterPlaceholders((String)script, (Map)ParameterUtils.convert((Map)paramsMap));
    }

    public void setSeatunnelParameters(SeatunnelParameters seatunnelParameters) {
        this.seatunnelParameters = seatunnelParameters;
    }
}

