/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sagemaker;

import com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.amazonaws.services.sagemaker.model.StartPipelineExecutionRequest;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.authentication.aws.AmazonSageMakerClientFactory;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.sagemaker.param.SagemakerConnectionParam;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.sagemaker.PipelineUtils;
import org.apache.dolphinscheduler.plugin.task.sagemaker.SagemakerParameters;
import org.apache.dolphinscheduler.plugin.task.sagemaker.SagemakerTaskException;
import org.apache.dolphinscheduler.plugin.task.sagemaker.SagemakerTaskExecutionContext;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagemakerTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SagemakerTask.class);
    private static final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true)).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true)).configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true)).propertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.UpperCamelCaseStrategy())).build();
    private SagemakerParameters parameters;
    private AmazonSageMaker client;
    private PipelineUtils utils;
    private PipelineUtils.PipelineId pipelineId;
    private SagemakerConnectionParam sagemakerConnectionParam;
    private SagemakerTaskExecutionContext sagemakerTaskExecutionContext;
    private TaskExecutionContext taskExecutionContext;

    public SagemakerTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        this.parameters = (SagemakerParameters)((Object)JSONUtils.parseObject((String)this.taskRequest.getTaskParams(), SagemakerParameters.class));
        if (this.parameters == null) {
            throw new SagemakerTaskException("Sagemaker task params is empty");
        }
        if (!this.parameters.checkParameters()) {
            throw new SagemakerTaskException("Sagemaker task params is not valid");
        }
        this.sagemakerTaskExecutionContext = this.parameters.generateExtendedContext(this.taskExecutionContext.getResourceParametersHelper());
        this.sagemakerConnectionParam = (SagemakerConnectionParam)DataSourceUtils.buildConnectionParams((DbType)DbType.valueOf((String)this.parameters.getType()), (String)this.sagemakerTaskExecutionContext.getConnectionParams());
        this.parameters.setUsername(this.sagemakerConnectionParam.getUserName());
        this.parameters.setPassword(this.sagemakerConnectionParam.getPassword());
        this.parameters.setAwsRegion(this.sagemakerConnectionParam.getAwsRegion());
        log.info("Initialize Sagemaker task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.parameters)));
        this.client = this.createClient();
        this.utils = new PipelineUtils();
    }

    public void submitApplication() throws TaskException {
        try {
            StartPipelineExecutionRequest request = this.createStartPipelineRequest();
            this.pipelineId = this.utils.startPipelineExecution(this.client, request);
            this.setAppIds(JSONUtils.toJsonString((Object)this.pipelineId));
        }
        catch (Exception e) {
            this.setExitStatusCode(-1);
            throw new TaskException("SageMaker task submit error", (Throwable)e);
        }
    }

    public void cancelApplication() {
        this.initPipelineId();
        try {
            this.utils.stopPipelineExecution(this.client, this.pipelineId);
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    public void trackApplicationStatus() throws TaskException {
        this.initPipelineId();
        this.exitStatusCode = this.utils.checkPipelineExecutionStatus(this.client, this.pipelineId);
    }

    private void initPipelineId() {
        if (this.pipelineId == null && StringUtils.isNotEmpty((CharSequence)this.getAppIds())) {
            this.pipelineId = (PipelineUtils.PipelineId)JSONUtils.parseObject((String)this.getAppIds(), PipelineUtils.PipelineId.class);
        }
        if (this.pipelineId == null) {
            throw new TaskException("sagemaker applicationID is null");
        }
    }

    public StartPipelineExecutionRequest createStartPipelineRequest() throws SagemakerTaskException {
        StartPipelineExecutionRequest startPipelineRequest;
        String requestJson = this.parameters.getSagemakerRequestJson();
        requestJson = this.parseRequstJson(requestJson);
        try {
            startPipelineRequest = (StartPipelineExecutionRequest)objectMapper.readValue(requestJson, StartPipelineExecutionRequest.class);
        }
        catch (Exception e) {
            log.error("can not parse SagemakerRequestJson from json: {}", (Object)requestJson);
            throw new SagemakerTaskException("can not parse SagemakerRequestJson ", e);
        }
        log.info("Sagemaker task create StartPipelineRequest: {}", (Object)startPipelineRequest);
        return startPipelineRequest;
    }

    public SagemakerParameters getParameters() {
        return this.parameters;
    }

    private String parseRequstJson(String requestJson) {
        Map paramsMap = this.taskRequest.getPrepareParamsMap();
        return ParameterUtils.convertParameterPlaceholders((String)requestJson, (Map)ParameterUtils.convert((Map)paramsMap));
    }

    protected AmazonSageMaker createClient() {
        Map awsProperties = PropertyUtils.getByPrefix((String)"aws.sagemaker.", (String)"");
        return AmazonSageMakerClientFactory.createAmazonSageMakerClient((Map)awsProperties);
    }
}

