/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.remoteshell;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.dolphinscheduler.plugin.datasource.ssh.SSHUtils;
import org.apache.dolphinscheduler.plugin.datasource.ssh.param.SSHConnectionParam;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.parser.TaskOutputParameterParser;
import org.apache.dolphinscheduler.plugin.task.api.utils.ProcessUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteExecutor
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteExecutor.class);
    static final String REMOTE_SHELL_HOME = "/tmp/dolphinscheduler-remote-shell-%s/";
    static final String STATUS_TAG_MESSAGE = "DOLPHINSCHEDULER-REMOTE-SHELL-TASK-STATUS-";
    static final int TRACK_INTERVAL = 5000;
    protected Map<String, String> taskOutputParams = new HashMap<String, String>();
    private SshClient sshClient;
    private ClientSession session;
    private SSHConnectionParam sshConnectionParam;

    public RemoteExecutor(SSHConnectionParam sshConnectionParam) {
        this.sshConnectionParam = sshConnectionParam;
        this.initClient();
    }

    private void initClient() {
        this.sshClient = SshClient.setUpDefaultClient();
        this.sshClient.start();
    }

    private ClientSession getSession() {
        if (this.session != null && this.session.isOpen()) {
            return this.session;
        }
        try {
            this.session = SSHUtils.getSession((SshClient)this.sshClient, (SSHConnectionParam)this.sshConnectionParam);
            if (this.session == null || !((AuthFuture)this.session.auth().verify()).isSuccess()) {
                throw new TaskException("SSH connection failed");
            }
        }
        catch (Exception e) {
            throw new TaskException("SSH connection failed", (Throwable)e);
        }
        return this.session;
    }

    public int run(String taskId, String localFile) throws IOException {
        try {
            String pid = this.getTaskPid(taskId);
            if (StringUtils.isEmpty((CharSequence)pid)) {
                this.saveCommand(taskId, localFile);
                String runCommand = String.format("nohup /bin/bash %s%s.sh >%s%s.log 2>&1 &", this.getRemoteShellHome(), taskId, this.getRemoteShellHome(), taskId);
                this.runRemote(runCommand);
            }
            this.track(taskId);
            return this.getTaskExitCode(taskId);
        }
        catch (Exception e) {
            throw new TaskException("Remote shell task error", (Throwable)e);
        }
    }

    public void track(String taskId) throws Exception {
        String pid;
        int logN = 0;
        log.info("Remote shell task log:");
        TaskOutputParameterParser taskOutputParameterParser = new TaskOutputParameterParser();
        do {
            pid = this.getTaskPid(taskId);
            String trackCommand = String.format("tail -n +%s %s%s.log", logN + 1, this.getRemoteShellHome(), taskId);
            String logLine = this.runRemote(trackCommand);
            if (StringUtils.isEmpty((CharSequence)logLine)) {
                Thread.sleep(5000L);
                continue;
            }
            logN += logLine.split("\n").length;
            log.info(logLine);
            taskOutputParameterParser.appendParseLog(logLine);
        } while (StringUtils.isNotEmpty((CharSequence)pid));
        this.taskOutputParams.putAll(taskOutputParameterParser.getTaskOutputParams());
    }

    public Map<String, String> getTaskOutputParams() {
        return this.taskOutputParams;
    }

    public Integer getTaskExitCode(String taskId) throws IOException {
        String trackCommand = String.format("tail -n 1 %s%s.log", this.getRemoteShellHome(), taskId);
        String logLine = this.runRemote(trackCommand);
        int exitCode = -1;
        log.info("Remote shell task run status: {}", (Object)logLine);
        if (logLine.contains(STATUS_TAG_MESSAGE)) {
            String status = StringUtils.substringAfter((String)logLine, (String)STATUS_TAG_MESSAGE).trim();
            if (status.equals("0")) {
                log.info("Remote shell task success");
                exitCode = 0;
            } else {
                log.error("Remote shell task failed");
                exitCode = Integer.parseInt(status);
            }
        }
        this.cleanData(taskId);
        return exitCode;
    }

    public void cleanData(String taskId) {
        String cleanCommand = String.format("rm %s%s.sh %s%s.log", this.getRemoteShellHome(), taskId, this.getRemoteShellHome(), taskId);
        try {
            this.runRemote(cleanCommand);
        }
        catch (Exception e) {
            log.error("Remote shell task clean data failed, but will not affect the task execution", (Throwable)e);
        }
    }

    public void kill(String taskId) throws IOException {
        String pid = this.getTaskPid(taskId);
        if (StringUtils.isEmpty((CharSequence)pid)) {
            log.warn("query remote-shell task remote process id with empty");
            return;
        }
        if (!NumberUtils.isParsable((String)pid)) {
            log.error("query remote-shell task remote process id error, pid {} can not parse to number", (Object)pid);
            return;
        }
        String remotePidStr = this.getAllRemotePidStr(pid);
        String killCommand = String.format("kill -9 %s", remotePidStr);
        log.info("prepare to execute kill command in host: {}, kill cmd: {}", (Object)this.sshConnectionParam.getHost(), (Object)killCommand);
        this.runRemote(killCommand);
        this.cleanData(taskId);
    }

    protected String getAllRemotePidStr(String pid) {
        String remoteProcessIdStr = "";
        String cmd = String.format("pstree -p %s", pid);
        log.info("query all process id cmd: {}", (Object)cmd);
        try {
            String rawPidStr = this.runRemote(cmd);
            remoteProcessIdStr = ProcessUtils.parsePidStr((String)rawPidStr);
            if (!remoteProcessIdStr.startsWith(pid)) {
                log.error("query remote process id error, [{}] first pid not equal [{}]", (Object)remoteProcessIdStr, (Object)pid);
                remoteProcessIdStr = pid;
            }
        }
        catch (Exception e) {
            log.error("query remote all process id error", (Throwable)e);
            remoteProcessIdStr = pid;
        }
        return remoteProcessIdStr;
    }

    public String getTaskPid(String taskId) throws IOException {
        String pidCommand = String.format("ps -ef | grep \"%s.sh\" | grep -v grep | awk '{print $2}'", taskId);
        return this.runRemote(pidCommand).trim();
    }

    public void saveCommand(String taskId, String localFile) throws IOException {
        String checkDirCommand = String.format("if [ ! -d %s ]; then mkdir -p %s; fi", this.getRemoteShellHome(), this.getRemoteShellHome());
        this.runRemote(checkDirCommand);
        this.uploadScript(taskId, localFile);
        log.info("The final script is: \n{}", (Object)this.runRemote(String.format("cat %s%s.sh", this.getRemoteShellHome(), taskId)));
    }

    public void uploadScript(String taskId, String localFile) throws IOException {
        String remotePath = this.getRemoteShellHome() + taskId + ".sh";
        log.info("upload script from local:{} to remote: {}", (Object)localFile, (Object)remotePath);
        try (SftpFileSystem fs = SftpClientFactory.instance().createSftpFileSystem(this.getSession());){
            Path path = fs.getPath(remotePath, new String[0]);
            Files.copy(Paths.get(localFile, new String[0]), path, new CopyOption[0]);
        }
    }

    /*
     * Exception decompiling
     */
    public String runRemote(String command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getRemoteShellHome() {
        return String.format(REMOTE_SHELL_HOME, this.sshConnectionParam.getUser());
    }

    @Override
    public void close() {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
        if (this.sshClient != null && this.sshClient.isStarted()) {
            this.sshClient.close();
        }
    }

    static class COMMAND {
        static final String CHECK_DIR = "if [ ! -d %s ]; then mkdir -p %s; fi";
        static final String RUN_COMMAND = "nohup /bin/bash %s%s.sh >%s%s.log 2>&1 &";
        static final String TRACK_COMMAND = "tail -n +%s %s%s.log";
        static final String LOG_TAIL_COMMAND = "tail -n 1 %s%s.log";
        static final String GET_PID_COMMAND = "ps -ef | grep \"%s.sh\" | grep -v grep | awk '{print $2}'";
        static final String KILL_COMMAND = "kill -9 %s";
        static final String CLEAN_COMMAND = "rm %s%s.sh %s%s.log";
        static final String HEADER = "#!/bin/bash\n";
        static final String ADD_STATUS_COMMAND = "\necho %s$?";
        static final String CAT_FINAL_SCRIPT = "cat %s%s.sh";
        static final String PSTREE_COMMAND = "pstree -p %s";

        private COMMAND() {
            throw new IllegalStateException("Utility class");
        }
    }
}

