/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.linkis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.shell.ShellInterceptorBuilderFactory;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.linkis.LinkisJobStatus;
import org.apache.dolphinscheduler.plugin.task.linkis.LinkisParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LinkisTask.class);
    private LinkisParameters linkisParameters;
    private ShellCommandExecutor shellCommandExecutor;
    protected final TaskExecutionContext taskExecutionContext;
    private String taskId;
    protected static final Pattern LINKIS_TASK_ID_REGEX = Pattern.compile("\"taskID\": \"\\d+");
    protected static final Pattern LINKIS_STATUS_REGEX = Pattern.compile("\"status\": \"\\w+");

    public LinkisTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((LinkisTask)this).logHandle(arg_0), taskExecutionContext);
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        this.linkisParameters = (LinkisParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), LinkisParameters.class));
        log.info("Initialize Linkis task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.linkisParameters)));
        if (!this.linkisParameters.checkParameters()) {
            throw new RuntimeException("Linkis task params is not valid");
        }
    }

    public void submitApplication() throws TaskException {
        try {
            IShellInterceptorBuilder shellActuatorBuilder = ShellInterceptorBuilderFactory.newBuilder().properties(ParameterUtils.convert((Map)this.taskExecutionContext.getPrepareParamsMap())).appendScript(this.buildCommand());
            TaskResponse commandExecuteResult = this.shellCommandExecutor.run(shellActuatorBuilder, null);
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setAppIds(this.findTaskId(commandExecuteResult.getResultString()));
            this.setProcessId(commandExecuteResult.getProcessId());
            this.linkisParameters.dealOutParam(this.shellCommandExecutor.getTaskOutputParams());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("The current Linkis task has been interrupted", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("The current Linkis task has been interrupted", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Linkis task error", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("Execute Linkis task failed", (Throwable)e);
        }
    }

    public void trackApplicationStatus() throws TaskException {
        this.initTaskId();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("${LINKIS_HOME}/bin/linkis-cli");
            args.add("--status");
            args.add(this.taskId);
            String command = String.join((CharSequence)" ", args);
            IShellInterceptorBuilder shellActuatorBuilder = ShellInterceptorBuilderFactory.newBuilder().appendScript(command);
            TaskResponse commandExecuteResult = this.shellCommandExecutor.run(shellActuatorBuilder, null);
            String status = this.findStatus(commandExecuteResult.getResultString());
            LinkisJobStatus jobStatus = LinkisJobStatus.convertFromJobStatusString(status);
            switch (jobStatus) {
                case FAILED: {
                    this.setExitStatusCode(-1);
                    break;
                }
                case SUCCEED: {
                    this.setExitStatusCode(0);
                    break;
                }
                case CANCELLED: {
                    this.setExitStatusCode(137);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("The current Linkis task has been interrupted", (Throwable)e);
            throw new TaskException("The current Linkis task has been interrupted", (Throwable)e);
        }
        catch (Exception e) {
            throw new TaskException("track linkis status error", (Throwable)e);
        }
    }

    public void cancelApplication() throws TaskException {
        this.initTaskId();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("${LINKIS_HOME}/bin/linkis-cli");
            args.add("--kill");
            args.add(this.taskId);
            String command = String.join((CharSequence)" ", args);
            IShellInterceptorBuilder shellActuatorBuilder = ShellInterceptorBuilderFactory.newBuilder().appendScript(command);
            this.shellCommandExecutor.run(shellActuatorBuilder, null);
            this.setExitStatusCode(137);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("The current Linkis task has been interrupted", (Throwable)e);
            throw new TaskException("The current Linkis task has been interrupted", (Throwable)e);
        }
        catch (Exception e) {
            throw new TaskException("cancel linkis task error", (Throwable)e);
        }
    }

    private String buildCommand() {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.buildOptions());
        String command = String.join((CharSequence)" ", args);
        log.info("Linkis task command: {}", (Object)command);
        return command;
    }

    protected List<String> buildOptions() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("${LINKIS_HOME}/bin/linkis-cli");
        args.add("--async true");
        if (BooleanUtils.isTrue((Boolean)this.linkisParameters.getUseCustom())) {
            args.add(this.linkisParameters.getRawScript());
        } else {
            args.add(this.buildParamConfigContent());
        }
        return args;
    }

    private String buildParamConfigContent() {
        log.info("raw param config content : {}", this.linkisParameters.getParamScript());
        String script = "";
        List<LinkisParameters.Param> paramList = this.linkisParameters.getParamScript();
        for (LinkisParameters.Param param : paramList) {
            script = script.concat(param.getProps()).concat(" ").concat(param.getValue());
        }
        return script;
    }

    private void initTaskId() {
        if (this.taskId == null && StringUtils.isNotEmpty((CharSequence)this.getAppIds())) {
            this.taskId = this.getAppIds();
        }
        if (this.taskId == null) {
            throw new TaskException("linkis task id is null");
        }
    }

    protected String findTaskId(String line) {
        Matcher matcher = LINKIS_TASK_ID_REGEX.matcher(line);
        if (matcher.find()) {
            String str = matcher.group();
            return str.substring(11);
        }
        return null;
    }

    protected String findStatus(String line) {
        Matcher matcher = LINKIS_STATUS_REGEX.matcher(line);
        if (matcher.find()) {
            String str = matcher.group();
            return str.substring(11);
        }
        return null;
    }

    public AbstractParameters getParameters() {
        return this.linkisParameters;
    }
}

