/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.linkis;

import org.apache.commons.lang3.StringUtils;

public enum LinkisJobStatus {
    UNSUBMITTED("Unsubmitted", 0),
    SUBMITTING("Submitting", 1),
    INITED("Inited", 2),
    WAIT_FOR_RETRY("WaitForRetry", 3),
    SCHEDULED("Scheduled", 4),
    RUNNING("Running", 5),
    SUCCEED("Succeed", 6),
    FAILED("Failed", 7),
    CANCELLED("Cancelled", 8),
    TIMEOUT("Timeout", 9),
    UNKNOWN("Unknown", 10),
    SHUTTINGDOWN("Shuttingdown", 11);

    private String name;
    private int id;

    private LinkisJobStatus(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public static LinkisJobStatus convertFromJobStatusString(String status) {
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (INITED.name().equalsIgnoreCase(status)) {
                return INITED;
            }
            if (WAIT_FOR_RETRY.name().equalsIgnoreCase(status)) {
                return WAIT_FOR_RETRY;
            }
            if (SCHEDULED.name().equalsIgnoreCase(status)) {
                return SCHEDULED;
            }
            if (RUNNING.name().equalsIgnoreCase(status)) {
                return RUNNING;
            }
            if (SUCCEED.name().equalsIgnoreCase(status)) {
                return SUCCEED;
            }
            if (FAILED.name().equalsIgnoreCase(status)) {
                return FAILED;
            }
            if (CANCELLED.name().equalsIgnoreCase(status)) {
                return CANCELLED;
            }
            if (TIMEOUT.name().equalsIgnoreCase(status)) {
                return TIMEOUT;
            }
            return UNKNOWN;
        }
        return UNKNOWN;
    }
}

