/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.kubeflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeflowHelper {
    protected final Logger log = LoggerFactory.getLogger(KubeflowHelper.class);
    private final String clusterConfigPath;
    private int messageIndex = 0;

    public KubeflowHelper(String clusterConfigPath) {
        this.clusterConfigPath = clusterConfigPath;
    }

    public String buildSubmitCommand(String yamlFilePATH) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.format("export KUBECONFIG=%s", this.clusterConfigPath));
        args.add(String.format("kubectl apply -f %s", yamlFilePATH));
        return String.join((CharSequence)"\n", args);
    }

    public String buildGetCommand(String yamlFilePATH) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.format("export KUBECONFIG=%s", this.clusterConfigPath));
        args.add(String.format("kubectl get -f %s -o json", yamlFilePATH));
        return String.join((CharSequence)"\n", args);
    }

    public String buildDeleteCommand(String yamlFilePATH) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.format("export KUBECONFIG=%s", this.clusterConfigPath));
        args.add(String.format("kubectl delete -f %s", yamlFilePATH));
        return String.join((CharSequence)"\n", args);
    }

    public String parseGetMessage(String message) {
        ObjectNode data = JSONUtils.parseObject((String)message);
        if (!data.has("status")) {
            return "";
        }
        JsonNode status = data.get("status");
        String lastConditionType = "";
        if (status.has("conditions")) {
            JsonNode conditions = status.get("conditions");
            for (int x = this.messageIndex; x < conditions.size(); ++x) {
                JsonNode condition = conditions.get(x);
                String stepMessage = condition.toString();
                this.log.info(stepMessage);
            }
            this.messageIndex = conditions.size();
            JsonNode lastCondition = conditions.get(conditions.size() - 1);
            String string = lastConditionType = lastCondition.has("type") ? lastCondition.get("type").asText() : "";
        }
        String phase = status.has("phase") ? status.get("phase").asText() : (StringUtils.isNotEmpty((CharSequence)lastConditionType) ? lastConditionType : "");
        return phase;
    }

    public static class COMMAND {
        public static final String SET_CONFIG = "export KUBECONFIG=%s";
        public static final String APPLY = "kubectl apply -f %s";
        public static final String GET = "kubectl get -f %s -o json";
        public static final String DELETE = "kubectl delete -f %s";
    }

    public static class CONSTANTS {
        public static final int TRACK_INTERVAL = 3000;
        public static final String YAML_FILE_PATH = "kubeflow.yaml";
        public static final String CLUSTER_CONFIG_PATH = ".cluster.yaml";
    }

    public static class STATUS {
        public static final HashSet<String> SUCCESS_SET = Sets.newHashSet((Object[])new String[]{"Succeeded", "Available", "Bound"});
        public static final HashSet<String> FAILED_SET = Sets.newHashSet((Object[])new String[]{"Failed"});
    }

    public static class ApplicationIds {
        boolean isAlreadySubmitted;

        @Generated
        public boolean isAlreadySubmitted() {
            return this.isAlreadySubmitted;
        }

        @Generated
        public void setAlreadySubmitted(boolean isAlreadySubmitted) {
            this.isAlreadySubmitted = isAlreadySubmitted;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationIds)) {
                return false;
            }
            ApplicationIds other = (ApplicationIds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isAlreadySubmitted() == other.isAlreadySubmitted();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApplicationIds;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAlreadySubmitted() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "KubeflowHelper.ApplicationIds(isAlreadySubmitted=" + this.isAlreadySubmitted() + ")";
        }

        @Generated
        public ApplicationIds(boolean isAlreadySubmitted) {
            this.isAlreadySubmitted = isAlreadySubmitted;
        }

        @Generated
        public ApplicationIds() {
        }
    }
}

