/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.dms;

import com.amazonaws.services.databasemigrationservice.model.InvalidResourceStateException;
import com.amazonaws.services.databasemigrationservice.model.ReplicationTask;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.dms.DmsHook;
import org.apache.dolphinscheduler.plugin.task.dms.DmsParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmsTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmsTask.class);
    private static final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true)).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true)).configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true)).propertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.UpperCamelCaseStrategy())).build();
    private final TaskExecutionContext taskExecutionContext;
    public DmsHook dmsHook;
    private DmsParameters parameters;
    private DmsHook.ApplicationIds appId;

    public DmsTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() throws TaskException {
        this.parameters = (DmsParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), DmsParameters.class));
        log.info("Initialize Dms task params {}", (Object)JSONUtils.toPrettyJsonString((Object)((Object)this.parameters)));
        this.initDmsHook();
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void submitApplication() throws TaskException {
        this.exitStatusCode = this.checkCreateReplicationTask();
        if (this.exitStatusCode != 0) {
            throw new TaskException("Failed to create a ReplicationTask");
        }
        this.exitStatusCode = this.startReplicationTask();
        if (this.exitStatusCode == -1 && !this.parameters.getIsRestartTask().booleanValue()) {
            this.dmsHook.deleteReplicationTask();
        } else {
            this.appId = this.dmsHook.getApplicationIds();
            this.setAppIds(JSONUtils.toJsonString((Object)this.appId));
        }
    }

    public void trackApplicationStatus() {
        this.initAppId();
        this.dmsHook.setReplicationTaskArn(this.appId.getReplicationTaskArn());
        if (this.isStopTaskWhenCdc().booleanValue()) {
            log.info("This is a cdc task and cdcStopPosition is not set, the task will not continue to check the running status");
            this.exitStatusCode = 0;
            return;
        }
        Boolean isFinishedSuccessfully = this.dmsHook.checkFinishedReplicationTask();
        if (!isFinishedSuccessfully.booleanValue()) {
            throw new TaskException("DMS task failed to track");
        }
        this.exitStatusCode = 0;
    }

    private void initAppId() {
        if (this.appId == null && StringUtils.isNotEmpty((CharSequence)this.getAppIds())) {
            this.appId = (DmsHook.ApplicationIds)JSONUtils.parseObject((String)this.getAppIds(), DmsHook.ApplicationIds.class);
        }
        if (this.appId == null) {
            throw new TaskException("DMS applicationID is null");
        }
    }

    public int checkCreateReplicationTask() throws TaskException {
        Boolean isCreateSuccessfully;
        if (this.parameters.getIsRestartTask().booleanValue()) {
            return 0;
        }
        try {
            isCreateSuccessfully = this.dmsHook.createReplicationTask();
        }
        catch (Exception e) {
            throw new TaskException("DMS task create replication task error", (Throwable)e);
        }
        if (isCreateSuccessfully.booleanValue()) {
            return 0;
        }
        return -1;
    }

    public int startReplicationTask() {
        Boolean isStartSuccessfully;
        block5: {
            isStartSuccessfully = false;
            try {
                isStartSuccessfully = this.dmsHook.startReplicationTask();
            }
            catch (InvalidResourceStateException e) {
                log.error("Failed to start a task, error message: {}", (Object)e.getErrorMessage());
                if (!e.getErrorMessage().contains("Test connection")) {
                    return -1;
                }
                log.info("restart replication task");
                if (this.parameters.getIsRestartTask().booleanValue()) {
                    this.dmsHook.describeReplicationTasks();
                }
                if (!this.dmsHook.testConnectionEndpoint().booleanValue()) break block5;
                isStartSuccessfully = this.dmsHook.startReplicationTask();
            }
        }
        if (!isStartSuccessfully.booleanValue()) {
            return -1;
        }
        return 0;
    }

    public Boolean isStopTaskWhenCdc() {
        ReplicationTask replicationTask = this.dmsHook.describeReplicationTasks();
        String migrationType = replicationTask.getMigrationType();
        return migrationType.contains("cdc") && this.parameters.getCdcStopPosition() == null;
    }

    public void initDmsHook() throws TaskException {
        this.convertJsonParameters();
        this.dmsHook = new DmsHook();
        try {
            BeanUtils.copyProperties((Object)this.dmsHook, (Object)((Object)this.parameters));
        }
        catch (Exception e) {
            throw new TaskException("DMS task init error", (Throwable)e);
        }
        if (!StringUtils.isNotEmpty((CharSequence)this.parameters.getStartReplicationTaskType())) {
            if (this.parameters.getIsRestartTask().booleanValue()) {
                this.dmsHook.setStartReplicationTaskType("reload-target");
            } else {
                this.dmsHook.setStartReplicationTaskType("start-replication");
            }
        }
    }

    public void convertJsonParameters() throws TaskException {
        if (this.parameters.getIsJsonFormat().booleanValue() && this.parameters.getJsonData() != null) {
            String jsonData = ParameterUtils.convertParameterPlaceholders((String)this.parameters.getJsonData(), (Map)ParameterUtils.convert((Map)this.taskExecutionContext.getPrepareParamsMap()));
            boolean isRestartTask = this.parameters.getIsRestartTask();
            try {
                this.parameters = (DmsParameters)((Object)objectMapper.readValue(jsonData, DmsParameters.class));
                this.parameters.setIsRestartTask(isRestartTask);
            }
            catch (Exception e) {
                log.error("Failed to convert json data to DmsParameters object.", (Throwable)e);
                throw new TaskException(e.getMessage());
            }
        }
    }

    public DmsParameters getParameters() {
        return this.parameters;
    }

    public void cancelApplication() {
        this.dmsHook.stopReplicationTask();
    }
}

