/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.DateInterval;

public class DependentDateUtils {
    public static List<DateInterval> getLastHoursInterval(Date businessDate, int hourNumber) {
        ArrayList<DateInterval> dateIntervals = new ArrayList<DateInterval>();
        if (hourNumber == 0) {
            Date lastHour = DateUtils.getSomeHourOfDay((Date)businessDate, (int)0);
            Date beginTime = DateUtils.getStartOfHour((Date)lastHour);
            Date endTime = DateUtils.getEndOfHour((Date)lastHour);
            dateIntervals.add(new DateInterval(beginTime, endTime));
            return dateIntervals;
        }
        for (int index = hourNumber; index > 0; --index) {
            Date lastHour = DateUtils.getSomeHourOfDay((Date)businessDate, (int)(-index));
            Date beginTime = DateUtils.getStartOfHour((Date)lastHour);
            Date endTime = DateUtils.getEndOfHour((Date)lastHour);
            dateIntervals.add(new DateInterval(beginTime, endTime));
        }
        return dateIntervals;
    }

    public static List<DateInterval> getTodayInterval(Date businessDate) {
        ArrayList<DateInterval> dateIntervals = new ArrayList<DateInterval>();
        Date beginTime = DateUtils.getStartOfDay((Date)businessDate);
        Date endTime = DateUtils.getEndOfDay((Date)businessDate);
        dateIntervals.add(new DateInterval(beginTime, endTime));
        return dateIntervals;
    }

    public static List<DateInterval> getLastDayInterval(Date businessDate, int someDay) {
        ArrayList<DateInterval> dateIntervals = new ArrayList<DateInterval>();
        for (int index = someDay; index > 0; --index) {
            Date lastDay = DateUtils.getSomeDay((Date)businessDate, (int)(-index));
            Date beginTime = DateUtils.getStartOfDay((Date)lastDay);
            Date endTime = DateUtils.getEndOfDay((Date)lastDay);
            dateIntervals.add(new DateInterval(beginTime, endTime));
        }
        return dateIntervals;
    }

    public static List<DateInterval> getSpecialLastDayInterval(Date businessDate) {
        ArrayList<DateInterval> dateIntervals = new ArrayList<DateInterval>();
        int hourIndex = DateUtils.getHourIndex((Date)businessDate);
        int startIndex = hourIndex + 23;
        int endIndex = startIndex - 24;
        for (int index = startIndex; index > endIndex; --index) {
            Date lastHour = DateUtils.getSomeHourOfDay((Date)businessDate, (int)(-index));
            Date beginTime = DateUtils.getStartOfHour((Date)lastHour);
            Date endTime = DateUtils.getEndOfHour((Date)lastHour);
            dateIntervals.add(new DateInterval(beginTime, endTime));
        }
        return dateIntervals;
    }

    public static List<DateInterval> getThisMonthInterval(Date businessDate) {
        Date firstDay = DateUtils.getFirstDayOfMonth((Date)businessDate);
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(firstDay, businessDate);
    }

    public static List<DateInterval> getLastMonthInterval(Date businessDate) {
        Date firstDayThisMonth = DateUtils.getFirstDayOfMonth((Date)businessDate);
        Date lastDay = DateUtils.getSomeDay((Date)firstDayThisMonth, (int)-1);
        Date firstDay = DateUtils.getFirstDayOfMonth((Date)lastDay);
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(firstDay, lastDay);
    }

    public static List<DateInterval> getNeededMonthBeginInterval(Date businessDate, boolean isBeginDay, int neededMonth) {
        Date firstDayThisMonth = DateUtils.getFirstDayOfMonth((Date)businessDate);
        Date lastDay = DateUtils.getSomeDay((Date)firstDayThisMonth, (int)neededMonth);
        Date firstDay = DateUtils.getFirstDayOfMonth((Date)lastDay);
        if (isBeginDay) {
            return DependentDateUtils.getDateIntervalListBetweenTwoDates(firstDay, firstDay);
        }
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(lastDay, lastDay);
    }

    public static List<DateInterval> getThisWeekInterval(Date businessDate) {
        Date mondayThisWeek = DateUtils.getMonday((Date)businessDate);
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(mondayThisWeek, businessDate);
    }

    public static List<DateInterval> getLastWeekInterval(Date businessDate) {
        Date mondayThisWeek = DateUtils.getMonday((Date)businessDate);
        Date sunday = DateUtils.getSomeDay((Date)mondayThisWeek, (int)-1);
        Date monday = DateUtils.getMonday((Date)sunday);
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(monday, sunday);
    }

    public static List<DateInterval> getLastWeekOneDayInterval(Date businessDate, int dayOfWeek) {
        Date mondayThisWeek = DateUtils.getMonday((Date)businessDate);
        Date sunday = DateUtils.getSomeDay((Date)mondayThisWeek, (int)-1);
        Date monday = DateUtils.getMonday((Date)sunday);
        Date destDay = DateUtils.getSomeDay((Date)monday, (int)(dayOfWeek - 1));
        return DependentDateUtils.getDateIntervalListBetweenTwoDates(destDay, destDay);
    }

    public static List<DateInterval> getDateIntervalListBetweenTwoDates(Date firstDay, Date lastDay) {
        ArrayList<DateInterval> dateIntervals = new ArrayList<DateInterval>();
        while (!firstDay.after(lastDay)) {
            Date beginTime = DateUtils.getStartOfDay((Date)firstDay);
            Date endTime = DateUtils.getEndOfDay((Date)firstDay);
            dateIntervals.add(new DateInterval(beginTime, endTime));
            firstDay = DateUtils.getSomeDay((Date)firstDay, (int)1);
        }
        return dateIntervals;
    }
}

