/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.log;

import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SensitiveDataConverter
extends MessageConverter {
    private static Pattern multilinePattern;
    private static final Set<String> maskPatterns;

    public String convert(ILoggingEvent event) {
        String requestLogMsg = event.getFormattedMessage();
        return SensitiveDataConverter.maskSensitiveData(requestLogMsg);
    }

    public static synchronized void addMaskPattern(String maskPattern) {
        if (maskPatterns.contains(maskPattern)) {
            return;
        }
        maskPatterns.add(maskPattern);
        multilinePattern = Pattern.compile(String.join((CharSequence)"|", maskPatterns), 8);
    }

    public static String maskSensitiveData(String logMsg) {
        if (StringUtils.isEmpty((CharSequence)logMsg)) {
            return logMsg;
        }
        StringBuffer sb = new StringBuffer(logMsg.length());
        Matcher matcher = multilinePattern.matcher(logMsg);
        while (matcher.find()) {
            matcher.appendReplacement(sb, "******");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    static {
        maskPatterns = new HashSet<String>();
        SensitiveDataConverter.addMaskPattern("(?<=((?i)password((\" : \")|(\":\")|(\\\\\":\\\\\")|(=')))).*?(?=((\")|(\\\\\")|(')))");
    }
}

