/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannel;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannelFactory;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.spi.plugin.PrioritySPIFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPluginManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskPluginManager.class);
    private static final Map<String, TaskChannel> taskChannelMap = new HashMap<String, TaskChannel>();
    private static final AtomicBoolean loadedFlag = new AtomicBoolean(false);

    public static void loadTaskPlugin() {
        if (!loadedFlag.compareAndSet(false, true)) {
            log.warn("The task plugin has already been loaded");
            return;
        }
        PrioritySPIFactory prioritySPIFactory = new PrioritySPIFactory(TaskChannelFactory.class);
        for (Map.Entry entry : prioritySPIFactory.getSPIMap().entrySet()) {
            String factoryName = (String)entry.getKey();
            TaskChannelFactory factory = (TaskChannelFactory)entry.getValue();
            taskChannelMap.put(factoryName, factory.create());
            log.info("Success register task plugin: {}", (Object)factoryName);
        }
    }

    public static TaskChannel getTaskChannel(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        TaskChannel taskChannel = taskChannelMap.get(type);
        if (taskChannel == null) {
            throw new IllegalArgumentException("Cannot find TaskChannel for : " + type);
        }
        return taskChannel;
    }

    public static boolean checkTaskParameters(String taskType, String taskParams) {
        AbstractParameters abstractParameters = TaskPluginManager.parseTaskParameters(taskType, taskParams);
        return abstractParameters.checkParameters();
    }

    public static AbstractParameters parseTaskParameters(String taskType, String taskParams) {
        Preconditions.checkNotNull((Object)taskType, (Object)"taskType cannot be null");
        TaskChannel taskChannel = TaskPluginManager.getTaskChannel(taskType);
        AbstractParameters abstractParameters = taskChannel.parseParameters(taskParams);
        if (abstractParameters == null) {
            throw new IllegalArgumentException("Cannot parse task parameters: " + taskParams + " for : " + taskType);
        }
        return abstractParameters;
    }

    static {
        TaskPluginManager.loadTaskPlugin();
    }
}

