/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.cos;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperatorFactory;
import org.apache.dolphinscheduler.plugin.storage.api.StorageType;
import org.apache.dolphinscheduler.plugin.storage.cos.CosStorageOperator;
import org.apache.dolphinscheduler.plugin.storage.cos.CosStorageProperties;

@AutoService(value={StorageOperatorFactory.class})
public class CosStorageOperatorFactory
implements StorageOperatorFactory {
    public StorageOperator createStorageOperate() {
        CosStorageProperties cosStorageProperties = this.getCosStorageProperties();
        return new CosStorageOperator(cosStorageProperties);
    }

    public StorageType getStorageOperate() {
        return StorageType.COS;
    }

    private CosStorageProperties getCosStorageProperties() {
        Map cosPropertiesMap = PropertyUtils.getByPrefix((String)"resource.tencent.cloud");
        return CosStorageProperties.builder().region((String)cosPropertiesMap.get("resource.tencent.cloud.cos.region")).accessKeyId((String)cosPropertiesMap.get("resource.tencent.cloud.access.key.id")).accessKeySecret((String)cosPropertiesMap.get("resource.tencent.cloud.access.key.secret")).bucketName((String)cosPropertiesMap.get("resource.tencent.cloud.cos.bucket.name")).resourceUploadPath(cosPropertiesMap.getOrDefault("resource.storage.upload.base.path", "/dolphinscheduler")).build();
    }
}

