/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.expand;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.mapper.ProjectParameterMapper;
import org.apache.dolphinscheduler.extract.master.command.ICommandParam;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.MapUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.PropertyUtils;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.expand.TimePlaceholderResolverExpandService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CuringParamsServiceImpl
implements CuringParamsService {
    @Autowired
    private TimePlaceholderResolverExpandService timePlaceholderResolverExpandService;
    @Autowired
    private ProjectParameterMapper projectParameterMapper;

    @Override
    public String convertParameterPlaceholders(String val, Map<String, Property> allParamMap) {
        Map<String, String> paramMap = allParamMap.entrySet().stream().filter(entry -> Objects.nonNull(((Property)entry.getValue()).getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Property)entry.getValue()).getValue()));
        return ParameterUtils.convertParameterPlaceholders((String)val, paramMap);
    }

    @Override
    public boolean timeFunctionNeedExpand(String placeholderName) {
        return this.timePlaceholderResolverExpandService.timeFunctionNeedExpand(placeholderName);
    }

    @Override
    public String timeFunctionExtension(Integer workflowInstanceId, String timezone, String placeholderName) {
        return this.timePlaceholderResolverExpandService.timeFunctionExtension(workflowInstanceId, timezone, placeholderName);
    }

    @Override
    public String curingGlobalParams(Integer workflowInstanceId, Map<String, String> globalParamMap, List<Property> globalParamList, CommandType commandType, Date scheduleTime, String timezone) {
        String val;
        if (globalParamList == null || globalParamList.isEmpty()) {
            return null;
        }
        HashMap<String, String> globalMap = new HashMap<String, String>();
        if (globalParamMap != null) {
            globalMap.putAll(globalParamMap);
        }
        HashMap<String, String> allParamMap = new HashMap<String, String>();
        Map timeParams = BusinessTimeUtils.getBusinessTime((CommandType)commandType, (Date)scheduleTime, (String)timezone);
        if (timeParams != null) {
            allParamMap.putAll(timeParams);
        }
        allParamMap.putAll(globalMap);
        Set entries = allParamMap.entrySet();
        HashMap resolveMap = new HashMap();
        for (Map.Entry entry : entries) {
            val = (String)entry.getValue();
            if (!val.contains("$")) continue;
            String str = val;
            if (this.timeFunctionNeedExpand(val)) {
                str = this.timeFunctionExtension(workflowInstanceId, timezone, val);
            }
            resolveMap.put(entry.getKey(), str);
        }
        globalMap.putAll(resolveMap);
        for (Property property : globalParamList) {
            val = (String)globalMap.get(property.getProp());
            if (val == null) continue;
            property.setValue(val);
        }
        return JSONUtils.toJsonString(globalParamList);
    }

    @Override
    public Map<String, Property> parseWorkflowStartParam(@Nullable Map<String, String> cmdParam) {
        if (cmdParam == null || !cmdParam.containsKey("StartParams")) {
            return new HashMap<String, Property>();
        }
        String startParamJson = cmdParam.get("StartParams");
        List propertyList = PropertyUtils.startParamsTransformPropertyList((String)startParamJson);
        if (CollectionUtils.isEmpty((Collection)propertyList)) {
            return new HashMap<String, Property>();
        }
        return propertyList.stream().collect(Collectors.toMap(Property::getProp, Function.identity()));
    }

    @Override
    public Map<String, Property> parseWorkflowFatherParam(@Nullable Map<String, String> cmdParam) {
        if (cmdParam == null || !cmdParam.containsKey("fatherParams")) {
            return new HashMap<String, Property>();
        }
        String startParamJson = cmdParam.get("fatherParams");
        Map startParamMap = JSONUtils.toMap((String)startParamJson);
        return startParamMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new Property((String)entry.getKey(), Direct.IN, DataType.VARCHAR, (String)entry.getValue())));
    }

    @Override
    public Map<String, Property> paramParsingPreparation(@NonNull TaskInstance taskInstance, @NonNull AbstractParameters parameters, @NonNull WorkflowInstance workflowInstance, String projectName, String workflowDefinitionName) {
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (workflowInstance == null) {
            throw new NullPointerException("workflowInstance is marked non-null but is null");
        }
        HashMap<String, Property> prepareParamsMap = new HashMap<String, Property>();
        Map<String, Property> globalParams = this.setGlobalParamsMap(workflowInstance);
        Map localParams = parameters.getInputLocalParametersMap();
        parameters.setVarPool(taskInstance.getVarPool());
        Map varParams = parameters.getVarPoolMap();
        ICommandParam commandParam = (ICommandParam)JSONUtils.parseObject((String)workflowInstance.getCommandParam(), ICommandParam.class);
        String timeZone = commandParam.getTimeZone();
        Map<String, String> builtInParams = this.setBuiltInParamsMap(taskInstance, workflowInstance, timeZone, projectName, workflowDefinitionName);
        Map<String, Property> projectParams = this.getProjectParameterMap(taskInstance.getProjectCode());
        if (MapUtils.isNotEmpty(builtInParams)) {
            prepareParamsMap.putAll(ParameterUtils.getUserDefParamsMap(builtInParams));
        }
        if (MapUtils.isNotEmpty(projectParams)) {
            prepareParamsMap.putAll(projectParams);
        }
        if (MapUtils.isNotEmpty(globalParams)) {
            prepareParamsMap.putAll(globalParams);
        }
        if (MapUtils.isNotEmpty((Map)varParams)) {
            prepareParamsMap.putAll(varParams);
        }
        if (MapUtils.isNotEmpty((Map)localParams)) {
            prepareParamsMap.putAll(localParams);
        }
        if (CollectionUtils.isNotEmpty((Collection)commandParam.getCommandParams())) {
            prepareParamsMap.putAll(commandParam.getCommandParams().stream().collect(Collectors.toMap(Property::getProp, Function.identity())));
        }
        for (Map.Entry en : prepareParamsMap.entrySet()) {
            Property property = (Property)en.getValue();
            if (!StringUtils.isNotEmpty((CharSequence)property.getValue()) || !property.getValue().contains("$")) continue;
            String val = property.getValue();
            val = this.timeFunctionNeedExpand(val) ? this.timeFunctionExtension(taskInstance.getWorkflowInstanceId(), timeZone, val) : this.convertParameterPlaceholders(val, prepareParamsMap);
            property.setValue(val);
        }
        Map<String, Property> paramsMap = this.preBuildBusinessParams(workflowInstance);
        if (MapUtils.isNotEmpty(paramsMap)) {
            prepareParamsMap.putAll(paramsMap);
        }
        return prepareParamsMap;
    }

    private Map<String, String> setBuiltInParamsMap(@NonNull TaskInstance taskInstance, WorkflowInstance workflowInstance, String timeZone, String projectName, String workflowDefinitionName) {
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        CommandType commandType = workflowInstance.getCmdTypeIfComplement();
        Date scheduleTime = workflowInstance.getScheduleTime();
        Map params = BusinessTimeUtils.getBusinessTime((CommandType)commandType, (Date)scheduleTime, (String)timeZone);
        if (StringUtils.isNotBlank((CharSequence)taskInstance.getExecutePath())) {
            params.put("system.task.execute.path", taskInstance.getExecutePath());
        }
        params.put("system.task.instance.id", Integer.toString(taskInstance.getId()));
        params.put("system.task.definition.name", taskInstance.getName());
        params.put("system.task.definition.code", Long.toString(taskInstance.getTaskCode()));
        params.put("system.workflow.instance.id", Integer.toString(taskInstance.getWorkflowInstanceId()));
        params.put("system.workflow.definition.name", workflowDefinitionName);
        params.put("system.workflow.definition.code", Long.toString(workflowInstance.getWorkflowDefinitionCode()));
        params.put("system.project.name", projectName);
        params.put("system.project.code", Long.toString(workflowInstance.getProjectCode()));
        return params;
    }

    private Map<String, Property> setGlobalParamsMap(WorkflowInstance workflowInstance) {
        HashMap<String, Property> globalParamsMap = new HashMap<String, Property>(16);
        String globalParamsStr = workflowInstance.getGlobalParams();
        if (globalParamsStr != null) {
            List globalParamsList = JSONUtils.toList((String)globalParamsStr, Property.class);
            globalParamsMap.putAll(globalParamsList.stream().collect(Collectors.toMap(Property::getProp, Function.identity())));
        }
        return globalParamsMap;
    }

    @Override
    public Map<String, Property> preBuildBusinessParams(WorkflowInstance workflowInstance) {
        HashMap<String, Property> paramsMap = new HashMap<String, Property>();
        if (workflowInstance.getScheduleTime() != null) {
            Date date = workflowInstance.getScheduleTime();
            String dateTime = DateUtils.format((Date)date, (String)"yyyyMMddHHmmss", null);
            Property p = new Property();
            p.setValue(dateTime);
            p.setProp("system.datetime");
            paramsMap.put("system.datetime", p);
        }
        return paramsMap;
    }

    @Override
    public Map<String, Property> getProjectParameterMap(long projectCode) {
        HashMap<String, Property> result = new HashMap<String, Property>(16);
        List projectParameterList = this.projectParameterMapper.queryByProjectCode(projectCode);
        projectParameterList.forEach(projectParameter -> {
            Property property = new Property(projectParameter.getParamName(), Direct.IN, Enum.valueOf(DataType.class, projectParameter.getParamDataType()), projectParameter.getParamValue());
            result.put(projectParameter.getParamName(), property);
        });
        return result;
    }
}

