/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.DependentRelation;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.model.DependentTaskModel;
import org.apache.dolphinscheduler.common.task.dependent.DependentParameters;
import org.apache.dolphinscheduler.common.utils.DependentUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;
import org.apache.dolphinscheduler.server.utils.DependentExecute;
import org.apache.dolphinscheduler.server.utils.LogUtils;

public class DependentTaskProcessor
extends BaseTaskProcessor {
    private DependentParameters dependentParameters;
    private List<DependentExecute> dependentTaskList = new ArrayList<DependentExecute>();
    private Map<String, DependResult> dependResultMap = new HashMap<String, DependResult>();
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date dependentDate;
    DependResult result;
    TaskDefinition taskDefinition;
    boolean allDependentItemFinished;

    @Override
    public boolean submitTask() {
        this.taskInstance = this.processService.submitTask(this.taskInstance, this.maxRetryTimes, this.commitInterval);
        if (this.taskInstance == null) {
            return false;
        }
        this.taskDefinition = this.processService.findTaskDefinition(this.taskInstance.getTaskCode(), this.taskInstance.getTaskDefinitionVersion());
        this.setTaskExecutionLogger();
        this.taskInstance.setLogPath(LogUtils.getTaskLogPath(this.processInstance.getProcessDefinitionCode(), this.processInstance.getProcessDefinitionVersion(), this.taskInstance.getProcessInstanceId(), this.taskInstance.getId()));
        this.taskInstance.setHost(NetUtils.getAddr((int)this.masterConfig.getListenPort()));
        this.taskInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
        this.taskInstance.setStartTime(new Date());
        this.processService.updateTaskInstance(this.taskInstance);
        this.initDependParameters();
        return true;
    }

    @Override
    protected boolean resubmitTask() {
        return true;
    }

    @Override
    public ExecutionStatus taskState() {
        return this.taskInstance.getState();
    }

    @Override
    public boolean runTask() {
        if (!this.allDependentItemFinished) {
            this.allDependentItemFinished = this.allDependentTaskFinish();
        }
        if (this.allDependentItemFinished) {
            this.getTaskDependResult();
            this.endTask();
        }
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        TaskTimeoutStrategy taskTimeoutStrategy = this.taskDefinition.getTimeoutNotifyStrategy();
        if (TaskTimeoutStrategy.FAILED != taskTimeoutStrategy && TaskTimeoutStrategy.WARNFAILED != taskTimeoutStrategy) {
            return true;
        }
        this.logger.info("dependent task {} timeout, strategy {} ", (Object)this.taskInstance.getId(), (Object)taskTimeoutStrategy.getDescp());
        this.result = DependResult.FAILED;
        this.endTask();
        return true;
    }

    private void initDependParameters() {
        this.dependentParameters = this.taskInstance.getDependency();
        for (DependentTaskModel taskModel : this.dependentParameters.getDependTaskList()) {
            this.dependentTaskList.add(new DependentExecute(taskModel.getDependItemList(), taskModel.getRelation()));
        }
        this.dependentDate = this.processInstance.getScheduleTime() != null ? this.processInstance.getScheduleTime() : new Date();
    }

    @Override
    protected boolean pauseTask() {
        this.taskInstance.setState(ExecutionStatus.PAUSE);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    @Override
    protected boolean persistTask(TaskAction taskAction) {
        switch (taskAction) {
            case STOP: {
                if (this.taskInstance.getState().typeIsFinished() && !this.taskInstance.getState().typeIsCancel()) {
                    return true;
                }
                this.taskInstance.setState(ExecutionStatus.KILL);
                this.taskInstance.setEndTime(new Date());
                this.processService.saveTaskInstance(this.taskInstance);
                return true;
            }
        }
        this.logger.error("unknown task action: {}", (Object)taskAction.toString());
        return false;
    }

    @Override
    protected boolean killTask() {
        this.taskInstance.setState(ExecutionStatus.KILL);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
        return true;
    }

    private boolean allDependentTaskFinish() {
        boolean finish = true;
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            for (Map.Entry<String, DependResult> entry : dependentExecute.getDependResultMap().entrySet()) {
                if (this.dependResultMap.containsKey(entry.getKey())) continue;
                this.dependResultMap.put(entry.getKey(), entry.getValue());
                this.logger.info("dependent item complete {} {},{}", new Object[]{":||", entry.getKey(), entry.getValue()});
            }
            if (dependentExecute.finish(this.dependentDate)) continue;
            finish = false;
        }
        return finish;
    }

    private DependResult getTaskDependResult() {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            DependResult dependResult = dependentExecute.getModelDependResult(this.dependentDate);
            dependResultList.add(dependResult);
        }
        this.result = DependentUtils.getDependResultForRelation((DependentRelation)this.dependentParameters.getRelation(), dependResultList);
        this.logger.info("dependent task completed, dependent result:{}", (Object)this.result);
        return this.result;
    }

    private void endTask() {
        ExecutionStatus status = this.result == DependResult.SUCCESS ? ExecutionStatus.SUCCESS : ExecutionStatus.FAILURE;
        this.taskInstance.setState(status);
        this.taskInstance.setEndTime(new Date());
        this.processService.saveTaskInstance(this.taskInstance);
    }

    @Override
    public String getType() {
        return TaskType.DEPENDENT.getDesc();
    }
}

