/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.TaskKillRequestCommand;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.dispatch.context.ExecutionContext;
import org.apache.dolphinscheduler.server.master.dispatch.enums.ExecutorType;
import org.apache.dolphinscheduler.server.master.dispatch.exceptions.ExecuteException;
import org.apache.dolphinscheduler.server.master.dispatch.executor.NettyExecutorManager;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.queue.TaskPriority;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueue;
import org.apache.dolphinscheduler.service.queue.TaskPriorityQueueImpl;
import org.apache.dolphinscheduler.service.queue.entity.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonTaskProcessor
extends BaseTaskProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CommonTaskProcessor.class);
    @Autowired
    private TaskPriorityQueue taskUpdateQueue;
    @Autowired
    NettyExecutorManager nettyExecutorManager = (NettyExecutorManager)SpringApplicationContext.getBean(NettyExecutorManager.class);

    @Override
    public boolean submitTask() {
        this.taskInstance = this.processService.submitTask(this.taskInstance, this.maxRetryTimes, this.commitInterval);
        if (this.taskInstance == null) {
            return false;
        }
        this.setTaskExecutionLogger();
        return this.dispatchTask(this.taskInstance, this.processInstance);
    }

    @Override
    public void setTaskExecutionLogger() {
        this.threadLoggerInfoName = LoggerUtils.buildTaskId((String)"TASK", (Long)this.processInstance.getProcessDefinitionCode(), (int)this.processInstance.getProcessDefinitionVersion(), (int)this.taskInstance.getProcessInstanceId(), (int)this.taskInstance.getId());
        Thread.currentThread().setName(String.format("CommonTask-%s", this.threadLoggerInfoName));
    }

    @Override
    public ExecutionStatus taskState() {
        return this.taskInstance.getState();
    }

    @Override
    public boolean runTask() {
        return true;
    }

    @Override
    protected boolean taskTimeout() {
        return true;
    }

    @Override
    protected boolean persistTask(TaskAction taskAction) {
        switch (taskAction) {
            case STOP: {
                if (this.taskInstance.getState().typeIsFinished() && !this.taskInstance.getState().typeIsCancel()) {
                    return true;
                }
                this.taskInstance.setState(ExecutionStatus.KILL);
                this.taskInstance.setEndTime(new Date());
                this.processService.updateTaskInstance(this.taskInstance);
                return true;
            }
        }
        logger.error("unknown task action: {}", (Object)taskAction.toString());
        return false;
    }

    @Override
    protected boolean pauseTask() {
        return true;
    }

    @Override
    public String getType() {
        return "common";
    }

    private boolean dispatchTask(TaskInstance taskInstance, ProcessInstance processInstance) {
        try {
            if (this.taskUpdateQueue == null) {
                this.initQueue();
            }
            if (taskInstance.getState().typeIsFinished()) {
                logger.info(String.format("submit task , but task [%s] state [%s] is already  finished. ", taskInstance.getName(), taskInstance.getState().toString()));
                return true;
            }
            if (taskInstance.getState() == ExecutionStatus.RUNNING_EXECUTION || taskInstance.getState() == ExecutionStatus.DELAY_EXECUTION) {
                logger.info("submit task, but the status of the task {} is already running or delayed.", (Object)taskInstance.getName());
                return true;
            }
            logger.info("task ready to submit: {}", (Object)taskInstance);
            TaskPriority taskPriority = new TaskPriority(processInstance.getProcessInstancePriority().getCode(), processInstance.getId(), taskInstance.getProcessInstancePriority().getCode(), taskInstance.getId(), "default");
            TaskExecutionContext taskExecutionContext = this.getTaskExecutionContext(taskInstance);
            taskPriority.setTaskExecutionContext(taskExecutionContext);
            this.taskUpdateQueue.put((Object)taskPriority);
            logger.info("master submit success, task id:{}, task name:{}, process id:{}", new Object[]{taskInstance.getId(), taskInstance.getName(), taskInstance.getProcessInstanceId()});
            return true;
        }
        catch (Exception e) {
            logger.error("submit task  Exception: ", (Throwable)e);
            logger.error("task error : {}", (Object)JSONUtils.toJsonString((Object)taskInstance));
            return false;
        }
    }

    public void initQueue() {
        this.taskUpdateQueue = (TaskPriorityQueue)SpringApplicationContext.getBean(TaskPriorityQueueImpl.class);
    }

    @Override
    public boolean killTask() {
        try {
            this.taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(this.taskInstance.getId()));
            if (this.taskInstance == null) {
                return true;
            }
            if (this.taskInstance.getState().typeIsFinished()) {
                return true;
            }
            if (StringUtils.isBlank((String)this.taskInstance.getHost())) {
                this.taskInstance.setState(ExecutionStatus.KILL);
                this.taskInstance.setEndTime(new Date());
                return true;
            }
            TaskKillRequestCommand killCommand = new TaskKillRequestCommand();
            killCommand.setTaskInstanceId(this.taskInstance.getId());
            ExecutionContext executionContext = new ExecutionContext(killCommand.convert2Command(), ExecutorType.WORKER);
            Host host = Host.of((String)this.taskInstance.getHost());
            executionContext.setHost(host);
            this.nettyExecutorManager.executeDirectly(executionContext);
        }
        catch (ExecuteException e) {
            logger.error("kill task error:", (Throwable)e);
            return false;
        }
        logger.info("master kill taskInstance name :{} taskInstance id:{}", (Object)this.taskInstance.getName(), (Object)this.taskInstance.getId());
        return true;
    }
}

