/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryClient;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FailoverExecuteThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(FailoverExecuteThread.class);
    @Autowired
    private MasterRegistryClient masterRegistryClient;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private ProcessService processService;

    @Override
    public synchronized void start() {
        super.setName("FailoverExecuteThread");
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (Stopper.isRunning()) {
            logger.info("failover execute started");
            try {
                List<String> hosts = this.getNeedFailoverMasterServers();
                if (CollectionUtils.isEmpty(hosts)) continue;
                logger.info("need failover hosts:{}", hosts);
                for (String host : hosts) {
                    String failoverPath = this.masterRegistryClient.getFailoverLockPath(NodeType.MASTER, host);
                    try {
                        this.registryClient.getLock(failoverPath);
                        this.masterRegistryClient.failoverMaster(host);
                    }
                    catch (Exception e) {
                        logger.error("{} server failover failed, host:{}", new Object[]{NodeType.MASTER, host, e});
                    }
                    finally {
                        this.registryClient.releaseLock(failoverPath);
                    }
                }
            }
            catch (Exception e) {
                logger.error("failover execute error", (Throwable)e);
            }
            finally {
                ThreadUtils.sleep((long)(1000L * (long)this.masterConfig.getFailoverInterval() * 60L));
            }
        }
    }

    private List<String> getNeedFailoverMasterServers() {
        List hosts = this.processService.queryNeedFailoverProcessInstanceHost();
        Iterator iterator = hosts.iterator();
        while (iterator.hasNext()) {
            String host = (String)iterator.next();
            if (!this.registryClient.checkNodeExists(host, NodeType.MASTER) || host.equals(this.masterRegistryClient.getLocalAddress())) continue;
            iterator.remove();
        }
        return hosts;
    }
}

