/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import com.google.common.base.Strings;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.registry.api.Event;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryClient;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterRegistryDataListener
implements SubscribeListener {
    private static final Logger logger = LoggerFactory.getLogger(MasterRegistryDataListener.class);
    private final MasterRegistryClient masterRegistryClient = (MasterRegistryClient)SpringApplicationContext.getBean(MasterRegistryClient.class);

    public void notify(Event event) {
        String path = event.path();
        if (Strings.isNullOrEmpty((String)path)) {
            return;
        }
        if (path.startsWith("/nodes/master/")) {
            this.handleMasterEvent(event);
        } else if (path.startsWith("/nodes/worker/")) {
            this.handleWorkerEvent(event);
        }
    }

    public void handleMasterEvent(Event event) {
        String path = event.path();
        switch (event.type()) {
            case ADD: {
                logger.info("master node added : {}", (Object)path);
                break;
            }
            case REMOVE: {
                this.masterRegistryClient.removeMasterNodePath(path, NodeType.MASTER, true);
                break;
            }
        }
    }

    public void handleWorkerEvent(Event event) {
        String path = event.path();
        switch (event.type()) {
            case ADD: {
                logger.info("worker node added : {}", (Object)path);
                break;
            }
            case REMOVE: {
                logger.info("worker node deleted : {}", (Object)path);
                this.masterRegistryClient.removeWorkerNodePath(path, NodeType.WORKER, true);
                break;
            }
        }
    }
}

