/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.log;

import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.log.LoggerRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerServer {
    private static final Logger logger = LoggerFactory.getLogger(LoggerServer.class);
    private final NettyRemotingServer server;
    private final NettyServerConfig serverConfig = new NettyServerConfig();
    private final LoggerRequestProcessor requestProcessor;

    public LoggerServer() {
        this.serverConfig.setListenPort(50051);
        this.server = new NettyRemotingServer(this.serverConfig);
        this.requestProcessor = new LoggerRequestProcessor();
        this.server.registerProcessor(CommandType.GET_LOG_BYTES_REQUEST, (NettyRequestProcessor)this.requestProcessor, this.requestProcessor.getExecutor());
        this.server.registerProcessor(CommandType.ROLL_VIEW_LOG_REQUEST, (NettyRequestProcessor)this.requestProcessor, this.requestProcessor.getExecutor());
        this.server.registerProcessor(CommandType.VIEW_WHOLE_LOG_REQUEST, (NettyRequestProcessor)this.requestProcessor, this.requestProcessor.getExecutor());
        this.server.registerProcessor(CommandType.REMOVE_TAK_LOG_REQUEST, (NettyRequestProcessor)this.requestProcessor, this.requestProcessor.getExecutor());
    }

    public static void main(String[] args) {
        LoggerServer server = new LoggerServer();
        server.start();
    }

    public void start() {
        this.server.start();
        logger.info("logger server started, listening on port : {}", (Object)50051);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LoggerServer.this.stop();
            }
        });
    }

    public void stop() {
        this.server.close();
        logger.info("logger server shut down");
    }
}

