/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.microbench.rpc;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.base.config.NettyServerConfig;
import org.apache.dolphinscheduler.extract.base.server.SpringServerMethodInvokerDiscovery;
import org.apache.dolphinscheduler.microbench.base.AbstractBaseBenchmark;
import org.apache.dolphinscheduler.microbench.rpc.IService;
import org.apache.dolphinscheduler.microbench.rpc.IServiceImpl;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Warmup(iterations=5, time=1)
@Measurement(iterations=10, time=1)
@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput, Mode.AverageTime, Mode.SampleTime})
public class RpcBenchMarkTest
extends AbstractBaseBenchmark {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RpcBenchMarkTest.class);
    private SpringServerMethodInvokerDiscovery springServerMethodInvokerDiscovery;
    private IService iService;

    @Setup
    public void before() {
        NettyServerConfig nettyServerConfig = NettyServerConfig.builder().serverName("NettyRemotingServer").listenPort(12345).build();
        this.springServerMethodInvokerDiscovery = new SpringServerMethodInvokerDiscovery(nettyServerConfig);
        this.springServerMethodInvokerDiscovery.postProcessAfterInitialization((Object)new IServiceImpl(), "iServiceImpl");
        this.springServerMethodInvokerDiscovery.start();
        this.iService = (IService)Clients.withService(IService.class).withHost("localhost:12345");
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput, Mode.AverageTime, Mode.SampleTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void sendTest(Blackhole bh) {
        String pong = this.iService.ping("ping");
        bh.consume((Object)pong);
    }

    @TearDown
    public void after() {
        this.springServerMethodInvokerDiscovery.close();
    }
}

