/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import lombok.Generated;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.config.MasterServerLoadProtection;
import org.apache.dolphinscheduler.server.master.engine.MasterCoordinator;
import org.apache.dolphinscheduler.server.master.registry.MasterConnectionStateListener;
import org.apache.dolphinscheduler.server.master.registry.MasterHeartBeatTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterRegistryClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterRegistryClient.class);
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private MasterServerLoadProtection masterServerLoadProtection;
    @Autowired
    private MetricsProvider metricsProvider;
    @Autowired
    private MasterCoordinator masterCoordinator;
    private MasterHeartBeatTask masterHeartBeatTask;

    public void start() {
        try {
            this.masterHeartBeatTask = new MasterHeartBeatTask(this.masterConfig, this.masterServerLoadProtection, this.metricsProvider, this.registryClient, this.masterCoordinator);
            this.registry();
            this.registryClient.addConnectionStateListener((ConnectionListener)new MasterConnectionStateListener(this.registryClient));
        }
        catch (Exception e) {
            throw new RegistryException("Master registry client start up error", (Throwable)e);
        }
    }

    public void setRegistryStoppable(IStoppable stoppable) {
        this.registryClient.setStoppable(stoppable);
    }

    @Override
    public void close() {
        if (this.masterHeartBeatTask != null) {
            this.masterHeartBeatTask.shutdown();
        }
        if (this.registryClient.isConnected()) {
            this.deregister();
        }
        log.info("Closed MasterRegistryClient");
    }

    void registry() {
        log.info("Master node : {} registering to registry center", (Object)this.masterConfig.getMasterAddress());
        String masterRegistryPath = this.masterConfig.getMasterRegistryPath();
        this.registryClient.remove(masterRegistryPath);
        this.registryClient.persistEphemeral(masterRegistryPath, JSONUtils.toJsonString((Object)this.masterHeartBeatTask.getHeartBeat()));
        while (!this.registryClient.checkNodeExists(NetUtils.getHost(), RegistryNodeType.MASTER)) {
            log.warn("The current master server node:{} cannot find in registry", (Object)NetUtils.getHost());
            ThreadUtils.sleep((long)1000L);
        }
        this.masterHeartBeatTask.start();
        log.info("Master node : {} registered to registry center successfully", (Object)this.masterConfig.getMasterAddress());
    }

    public void deregister() {
        try {
            this.registryClient.remove(this.masterConfig.getMasterRegistryPath());
            log.info("Master node : {} unRegistry to register center.", (Object)this.masterConfig.getMasterAddress());
            if (this.masterHeartBeatTask != null) {
                this.masterHeartBeatTask.shutdown();
            }
            this.registryClient.close();
        }
        catch (Exception e) {
            log.error("MasterServer remove registry path exception ", (Throwable)e);
        }
    }

    public boolean isAvailable() {
        return this.registryClient.isConnected();
    }
}

