/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.trigger;

import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.utils.EnvironmentUtils;
import org.apache.dolphinscheduler.dao.utils.WorkerGroupUtils;
import org.apache.dolphinscheduler.extract.master.command.RunWorkflowCommandParam;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowManualTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowManualTriggerResponse;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.AbstractWorkflowTrigger;
import org.springframework.stereotype.Component;

@Component
public class WorkflowManualTrigger
extends AbstractWorkflowTrigger<WorkflowManualTriggerRequest, WorkflowManualTriggerResponse> {
    @Override
    protected WorkflowInstance constructWorkflowInstance(WorkflowManualTriggerRequest workflowManualTriggerRequest) {
        CommandType commandType = CommandType.START_PROCESS;
        Long workflowCode = workflowManualTriggerRequest.getWorkflowDefinitionCode();
        Integer workflowVersion = workflowManualTriggerRequest.getWorkflowDefinitionVersion();
        WorkflowDefinition workflowDefinition = this.getProcessDefinition(workflowCode, workflowVersion);
        WorkflowInstance workflowInstance = new WorkflowInstance();
        workflowInstance.setWorkflowDefinitionCode(Long.valueOf(workflowDefinition.getCode()));
        workflowInstance.setWorkflowDefinitionVersion(workflowDefinition.getVersion());
        workflowInstance.setProjectCode(Long.valueOf(workflowDefinition.getProjectCode()));
        workflowInstance.setCommandType(commandType);
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.SUBMITTED_SUCCESS, commandType.name());
        workflowInstance.setRecovery(Flag.NO);
        workflowInstance.setStartTime(new Date());
        workflowInstance.setRestartTime(workflowInstance.getStartTime());
        workflowInstance.setRunTimes(1);
        workflowInstance.setName(String.join((CharSequence)"-", workflowDefinition.getName(), DateUtils.getCurrentTimeStamp()));
        workflowInstance.setTaskDependType(workflowManualTriggerRequest.getTaskDependType());
        workflowInstance.setFailureStrategy(workflowManualTriggerRequest.getFailureStrategy());
        workflowInstance.setWarningType((WarningType)ObjectUtils.defaultIfNull((Object)workflowManualTriggerRequest.getWarningType(), (Object)WarningType.NONE));
        workflowInstance.setWarningGroupId(workflowManualTriggerRequest.getWarningGroupId());
        workflowInstance.setExecutorId(workflowManualTriggerRequest.getUserId().intValue());
        workflowInstance.setExecutorName(this.getExecutorUser(workflowManualTriggerRequest.getUserId()).getUserName());
        workflowInstance.setTenantCode(workflowManualTriggerRequest.getTenantCode());
        workflowInstance.setIsSubWorkflow(Flag.NO);
        workflowInstance.addHistoryCmd(commandType);
        workflowInstance.setWorkflowInstancePriority(workflowManualTriggerRequest.getWorkflowInstancePriority());
        workflowInstance.setWorkerGroup(WorkerGroupUtils.getWorkerGroupOrDefault((String)workflowManualTriggerRequest.getWorkerGroup()));
        workflowInstance.setEnvironmentCode(EnvironmentUtils.getEnvironmentCodeOrDefault((Long)workflowManualTriggerRequest.getEnvironmentCode()));
        workflowInstance.setTimeout(workflowDefinition.getTimeout());
        workflowInstance.setDryRun(workflowManualTriggerRequest.getDryRun().getCode());
        return workflowInstance;
    }

    @Override
    protected Command constructTriggerCommand(WorkflowManualTriggerRequest workflowManualTriggerRequest, WorkflowInstance workflowInstance) {
        RunWorkflowCommandParam runWorkflowCommandParam = ((RunWorkflowCommandParam.RunWorkflowCommandParamBuilder)((RunWorkflowCommandParam.RunWorkflowCommandParamBuilder)((RunWorkflowCommandParam.RunWorkflowCommandParamBuilder)RunWorkflowCommandParam.builder().commandParams(workflowManualTriggerRequest.getStartParamList())).startNodes(workflowManualTriggerRequest.getStartNodes())).timeZone(DateUtils.getTimezone())).build();
        return Command.builder().commandType(CommandType.START_PROCESS).workflowDefinitionCode(workflowManualTriggerRequest.getWorkflowDefinitionCode().longValue()).workflowDefinitionVersion(workflowManualTriggerRequest.getWorkflowDefinitionVersion().intValue()).workflowInstanceId(workflowInstance.getId().intValue()).workflowInstancePriority(workflowInstance.getWorkflowInstancePriority()).commandParam(JSONUtils.toJsonString((Object)runWorkflowCommandParam)).build();
    }

    @Override
    protected WorkflowManualTriggerResponse onTriggerSuccess(WorkflowInstance workflowInstance) {
        return WorkflowManualTriggerResponse.success((Integer)workflowInstance.getId());
    }
}

