/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.lifecycle.handler;

import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.TaskLifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskKillLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskTimeoutLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.handler.AbstractTaskLifecycleEventHandler;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.statemachine.ITaskStateAction;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.service.alert.WorkflowAlertManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskTimeoutLifecycleEventHandler
extends AbstractTaskLifecycleEventHandler<TaskTimeoutLifecycleEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskTimeoutLifecycleEventHandler.class);
    private final WorkflowAlertManager workflowAlertManager;

    public TaskTimeoutLifecycleEventHandler(WorkflowAlertManager workflowAlertManager) {
        this.workflowAlertManager = workflowAlertManager;
    }

    @Override
    public void handle(ITaskStateAction taskStateAction, IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable, TaskTimeoutLifecycleEvent taskTimeoutLifecycleEvent) {
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecutionGraph();
        if (!workflowExecutionGraph.isTaskExecutionRunnableActive(taskExecutionRunnable)) {
            return;
        }
        TaskDefinition taskDefinition = taskExecutionRunnable.getTaskDefinition();
        String taskName = taskExecutionRunnable.getName();
        TaskTimeoutStrategy timeoutNotifyStrategy = taskDefinition.getTimeoutNotifyStrategy();
        if (timeoutNotifyStrategy == null) {
            log.info("The task {} TimeoutStrategy is null.", (Object)taskName);
            return;
        }
        switch (timeoutNotifyStrategy) {
            case WARN: {
                log.info("The task {} TimeoutStrategy is WARN, try to send a timeout alert.", (Object)taskName);
                this.doTaskTimeoutAlert(taskExecutionRunnable);
                break;
            }
            case FAILED: {
                log.info("The task {} TimeoutStrategy is FAILED, try to publish a kill event.", (Object)taskName);
                this.doTaskTimeoutKill(taskExecutionRunnable);
                break;
            }
            case WARNFAILED: {
                log.info("The task {} TimeoutStrategy is WARNFAILED, try to publish a kill event and send a timeout alert.", (Object)taskName);
                this.doTaskTimeoutKill(taskExecutionRunnable);
                this.doTaskTimeoutAlert(taskExecutionRunnable);
            }
            default: {
                log.warn("The task {} TimeoutStrategy is invalided.", (Object)taskName);
            }
        }
    }

    private void doTaskTimeoutKill(ITaskExecutionRunnable taskExecutionRunnable) {
        taskExecutionRunnable.getWorkflowEventBus().publish(TaskKillLifecycleEvent.of(taskExecutionRunnable));
    }

    private void doTaskTimeoutAlert(ITaskExecutionRunnable taskExecutionRunnable) {
        WorkflowInstance workflowInstance = taskExecutionRunnable.getWorkflowInstance();
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        this.workflowAlertManager.sendTaskTimeoutAlert(workflowInstance, taskInstance, null);
    }

    @Override
    public ILifecycleEventType matchEventType() {
        return TaskLifecycleEventType.TIMEOUT;
    }
}

