/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.statemachine;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.engine.AbstractLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.WorkflowCacheRepository;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBus;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBusCoordinator;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.SuccessorFlowAdjuster;
import org.apache.dolphinscheduler.server.master.engine.task.lifecycle.event.TaskStartLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowFinalizeLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.statemachine.IWorkflowStateAction;
import org.apache.dolphinscheduler.server.master.utils.WorkflowInstanceUtils;
import org.apache.dolphinscheduler.service.alert.WorkflowAlertManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWorkflowStateAction
implements IWorkflowStateAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkflowStateAction.class);
    @Autowired
    protected SuccessorFlowAdjuster successorFlowAdjuster;
    @Autowired
    protected WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    protected WorkflowCacheRepository workflowCacheRepository;
    @Autowired
    protected WorkflowEventBusCoordinator workflowEventBusCoordinator;
    @Autowired
    protected WorkflowAlertManager workflowAlertManager;

    protected void triggerTasks(IWorkflowExecutionRunnable workflowExecutionRunnable, List<ITaskExecutionRunnable> taskExecutionRunnables) {
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecutionGraph();
        List readyTaskExecutionRunnableList = taskExecutionRunnables.stream().filter(workflowExecutionGraph::isTriggerConditionMet).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(readyTaskExecutionRunnableList)) {
            this.emitWorkflowFinishedEventIfApplicable(workflowExecutionRunnable);
            return;
        }
        WorkflowEventBus workflowEventBus = workflowExecutionRunnable.getWorkflowEventBus();
        for (ITaskExecutionRunnable readyTaskExecutionRunnable : readyTaskExecutionRunnableList) {
            workflowExecutionGraph.markTaskExecutionRunnableActive(readyTaskExecutionRunnable);
            if (workflowExecutionGraph.isTaskExecutionRunnableSkipped(readyTaskExecutionRunnable) || workflowExecutionGraph.isTaskExecutionRunnableForbidden(readyTaskExecutionRunnable)) {
                workflowExecutionGraph.markTaskExecutionRunnableInActive(readyTaskExecutionRunnable);
                workflowEventBus.publish(WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent.of(workflowExecutionRunnable, readyTaskExecutionRunnable));
                continue;
            }
            workflowEventBus.publish(TaskStartLifecycleEvent.of(readyTaskExecutionRunnable));
        }
    }

    protected void killActiveTask(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        try {
            LogUtils.setWorkflowInstanceIdMDC((Integer)workflowExecutionRunnable.getId());
            workflowExecutionRunnable.getWorkflowExecutionGraph().getActiveTaskExecutionRunnable().forEach(ITaskExecutionRunnable::kill);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    protected void pauseActiveTask(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        try {
            LogUtils.setWorkflowInstanceIdMDC((Integer)workflowExecutionRunnable.getId());
            workflowExecutionRunnable.getWorkflowExecutionGraph().getActiveTaskExecutionRunnable().forEach(ITaskExecutionRunnable::pause);
        }
        finally {
            LogUtils.removeWorkflowInstanceIdMDC();
        }
    }

    protected void tryToTriggerSuccessorsAfterTaskFinish(IWorkflowExecutionRunnable workflowExecutionRunnable, ITaskExecutionRunnable taskExecutionRunnable) {
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecutionGraph();
        if (workflowExecutionGraph.isEndOfTaskChain(taskExecutionRunnable)) {
            this.emitWorkflowFinishedEventIfApplicable(workflowExecutionRunnable);
            return;
        }
        this.successorFlowAdjuster.adjustSuccessorFlow(taskExecutionRunnable);
        this.triggerTasks(workflowExecutionRunnable, workflowExecutionGraph.getSuccessors(taskExecutionRunnable));
    }

    protected void workflowFinish(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowExecutionStatus workflowExecutionStatus) {
        WorkflowInstance workflowInstance = workflowExecutionRunnable.getWorkflowInstance();
        workflowInstance.setEndTime(new Date());
        this.transformWorkflowInstanceState(workflowExecutionRunnable, workflowExecutionStatus);
        workflowExecutionRunnable.getWorkflowEventBus().publish(WorkflowFinalizeLifecycleEvent.of(workflowExecutionRunnable));
    }

    protected void transformWorkflowInstanceState(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowExecutionStatus targetState) {
        WorkflowInstance workflowInstance = workflowExecutionRunnable.getWorkflowInstance();
        WorkflowExecutionStatus originState = workflowInstance.getState();
        try {
            workflowInstance.setState(targetState);
            this.workflowInstanceDao.updateById((Object)workflowInstance);
            log.info("Success set WorkflowExecuteRunnable: {} state from: {} to {}", new Object[]{workflowInstance.getName(), originState.name(), targetState.name()});
        }
        catch (Exception ex) {
            workflowInstance.setState(originState);
            throw ex;
        }
    }

    protected abstract void emitWorkflowFinishedEventIfApplicable(IWorkflowExecutionRunnable var1);

    protected void throwExceptionIfStateIsNotMatch(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        Preconditions.checkNotNull((Object)workflowExecutionRunnable, (Object)"workflowExecutionRunnable is null");
        WorkflowExecutionStatus actualState = workflowExecutionRunnable.getState();
        WorkflowExecutionStatus expectState = this.matchState();
        if (actualState != expectState) {
            String workflowName = workflowExecutionRunnable.getName();
            throw new IllegalStateException("The workflow: " + workflowName + " state: " + actualState + " is not match:" + expectState);
        }
    }

    protected void logWarningIfCannotDoAction(IWorkflowExecutionRunnable workflowExecutionRunnable, AbstractLifecycleEvent event) {
        log.warn("Workflow {} state is {} cannot do action on event: {}", new Object[]{workflowExecutionRunnable.getName(), workflowExecutionRunnable.getState(), event});
    }

    protected void finalizeEventAction(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        log.info(WorkflowInstanceUtils.logWorkflowInstanceInDetails(workflowExecutionRunnable));
        this.workflowCacheRepository.remove(workflowExecutionRunnable.getId());
        this.workflowEventBusCoordinator.unRegisterWorkflowEventBus(workflowExecutionRunnable);
        this.workflowAlertManager.sendAlertWorkflowInstance(workflowExecutionRunnable.getWorkflowInstance());
        log.info("Successfully finalize WorkflowExecuteRunnable: {}", (Object)workflowExecutionRunnable.getName());
    }
}

