/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.command.handler;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.ProjectDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionLogDao;
import org.apache.dolphinscheduler.extract.master.command.ICommandParam;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBus;
import org.apache.dolphinscheduler.server.master.engine.command.ICommandHandler;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.WorkflowGraphFactory;
import org.apache.dolphinscheduler.server.master.engine.workflow.listener.IWorkflowLifecycleListener;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.WorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.WorkflowExecutionRunnableBuilder;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class AbstractCommandHandler
implements ICommandHandler {
    @Autowired
    protected WorkflowDefinitionLogDao workflowDefinitionLogDao;
    @Autowired
    protected WorkflowGraphFactory workflowGraphFactory;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected TaskInstanceDao taskInstanceDao;
    @Autowired
    protected List<IWorkflowLifecycleListener> workflowLifecycleListeners;
    @Autowired
    protected ProjectDao projectDao;

    @Override
    public WorkflowExecutionRunnable handleCommand(Command command) {
        WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder = WorkflowExecuteContext.builder().withCommand(command);
        this.assembleWorkflowDefinition(workflowExecuteContextBuilder);
        this.assembleProject(workflowExecuteContextBuilder);
        this.assembleWorkflowGraph(workflowExecuteContextBuilder);
        this.assembleWorkflowInstance(workflowExecuteContextBuilder);
        this.assembleWorkflowInstanceLifecycleListeners(workflowExecuteContextBuilder);
        this.assembleWorkflowEventBus(workflowExecuteContextBuilder);
        this.assembleWorkflowExecutionGraph(workflowExecuteContextBuilder);
        WorkflowExecutionRunnableBuilder workflowExecutionRunnableBuilder = WorkflowExecutionRunnableBuilder.builder().workflowExecuteContextBuilder(workflowExecuteContextBuilder).applicationContext(this.applicationContext).build();
        return new WorkflowExecutionRunnable(workflowExecutionRunnableBuilder);
    }

    protected void assembleWorkflowEventBus(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        workflowExecuteContextBuilder.setWorkflowEventBus(new WorkflowEventBus());
    }

    protected void assembleWorkflowInstanceLifecycleListeners(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        workflowExecuteContextBuilder.setWorkflowInstanceLifecycleListeners(this.workflowLifecycleListeners);
    }

    protected void assembleWorkflowDefinition(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        int workflowDefinitionVersion;
        Command command = workflowExecuteContextBuilder.getCommand();
        long workflowDefinitionCode = command.getWorkflowDefinitionCode();
        WorkflowDefinitionLog workflowDefinition = this.workflowDefinitionLogDao.queryByDefinitionCodeAndVersion(workflowDefinitionCode, workflowDefinitionVersion = command.getWorkflowDefinitionVersion());
        Preconditions.checkArgument((workflowDefinition != null ? 1 : 0) != 0, (Object)("Cannot find the WorkflowDefinition: [" + workflowDefinitionCode + ":" + workflowDefinitionVersion + "]"));
        workflowExecuteContextBuilder.setWorkflowDefinition((WorkflowDefinition)workflowDefinition);
    }

    protected void assembleWorkflowGraph(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        WorkflowDefinition workflowDefinition = workflowExecuteContextBuilder.getWorkflowDefinition();
        workflowExecuteContextBuilder.setWorkflowGraph(this.workflowGraphFactory.createWorkflowGraph(workflowDefinition));
    }

    protected abstract void assembleWorkflowInstance(WorkflowExecuteContext.WorkflowExecuteContextBuilder var1);

    protected abstract void assembleWorkflowExecutionGraph(WorkflowExecuteContext.WorkflowExecuteContextBuilder var1);

    protected List<String> parseStartNodesFromWorkflowInstance(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        WorkflowInstance workflowInstance = workflowExecuteContextBuilder.getWorkflowInstance();
        ICommandParam commandParam = (ICommandParam)JSONUtils.parseObject((String)workflowInstance.getCommandParam(), ICommandParam.class);
        Preconditions.checkArgument((commandParam != null ? 1 : 0) != 0, (Object)("Invalid command param : " + workflowInstance.getCommandParam()));
        List startCodes = commandParam.getStartNodes();
        if (CollectionUtils.isEmpty((Collection)startCodes)) {
            return Collections.emptyList();
        }
        IWorkflowGraph workflowGraph = workflowExecuteContextBuilder.getWorkflowGraph();
        return startCodes.stream().map(workflowGraph::getTaskNodeByCode).map(TaskDefinition::getName).collect(Collectors.toList());
    }

    protected List<TaskInstance> getValidTaskInstance(WorkflowInstance workflowInstance) {
        return this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(workflowInstance.getId(), workflowInstance.getTestFlag());
    }

    protected void assembleProject(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        WorkflowDefinition workflowDefinition = workflowExecuteContextBuilder.getWorkflowDefinition();
        Project project = this.projectDao.queryByCode(Long.valueOf(workflowDefinition.getProjectCode()));
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (Object)("Cannot find the project code: " + workflowDefinition.getProjectCode()));
        workflowExecuteContextBuilder.setProject(project);
    }
}

