/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.dolphinscheduler.extract.base.server.ServerMethodInvoker;

class ServerMethodInvokerImpl
implements ServerMethodInvoker {
    private final Object serviceBean;
    private final Method method;
    private final String methodIdentify;

    ServerMethodInvokerImpl(Object serviceBean, Method method) {
        this.serviceBean = serviceBean;
        this.method = method;
        this.methodIdentify = method.toGenericString();
    }

    @Override
    public Object invoke(Object ... args) throws Throwable {
        try {
            return this.method.invoke(this.serviceBean, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    @Override
    public String getMethodIdentify() {
        return this.methodIdentify;
    }

    @Override
    public String getMethodProviderIdentify() {
        return this.serviceBean.getClass().getName();
    }
}

