/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.trino.param;

import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.trino.param.TrinoConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.trino.param.TrinoDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class TrinoDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, TrinoDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        TrinoConnectionParam connectionParams = (TrinoConnectionParam)this.createConnectionParams(connectionJson);
        String[] hostSeperator = connectionParams.getAddress().split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        TrinoDataSourceParamDTO TrinoDatasourceParamDTO = new TrinoDataSourceParamDTO();
        String[] split = hostPortArray[0].split(":");
        TrinoDatasourceParamDTO.setHost(split[0]);
        TrinoDatasourceParamDTO.setPort(Integer.valueOf(split[1]));
        TrinoDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        TrinoDatasourceParamDTO.setUserName(connectionParams.getUser());
        TrinoDatasourceParamDTO.setOther(connectionParams.getOther());
        return TrinoDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        TrinoDataSourceParamDTO TrinoParam = (TrinoDataSourceParamDTO)datasourceParam;
        String address = String.format("%s%s:%s", "jdbc:trino://", TrinoParam.getHost(), TrinoParam.getPort());
        String jdbcUrl = address + "/" + TrinoParam.getDatabase();
        TrinoConnectionParam TrinoConnectionParam2 = new TrinoConnectionParam();
        TrinoConnectionParam2.setUser(TrinoParam.getUserName());
        TrinoConnectionParam2.setPassword(PasswordUtils.encodePassword((String)TrinoParam.getPassword()));
        TrinoConnectionParam2.setOther(TrinoParam.getOther());
        TrinoConnectionParam2.setAddress(address);
        TrinoConnectionParam2.setJdbcUrl(jdbcUrl);
        TrinoConnectionParam2.setDatabase(TrinoParam.getDatabase());
        TrinoConnectionParam2.setDriverClassName(this.getDatasourceDriver());
        TrinoConnectionParam2.setValidationQuery(this.getValidationQuery());
        return TrinoConnectionParam2;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, TrinoConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "io.trino.jdbc.TrinoDriver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        TrinoConnectionParam TrinoConnectionParam2 = (TrinoConnectionParam)connectionParam;
        if (MapUtils.isNotEmpty((Map)TrinoConnectionParam2.getOther())) {
            return String.format("%s?%s", TrinoConnectionParam2.getJdbcUrl(), this.transformOther(TrinoConnectionParam2.getOther()));
        }
        return TrinoConnectionParam2.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        TrinoConnectionParam TrinoConnectionParam2 = (TrinoConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), TrinoConnectionParam2.getUser(), PasswordUtils.decodePassword((String)TrinoConnectionParam2.getPassword()));
    }

    public DbType getDbType() {
        return DbType.TRINO;
    }

    public DataSourceProcessor create() {
        return new TrinoDataSourceProcessor();
    }

    public List<String> splitAndRemoveComment(String sql) {
        String cleanSQL = SQLParserUtils.removeComment((String)sql, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.trino);
        return SQLParserUtils.split((String)cleanSQL, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.trino);
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isNotEmpty(otherMap)) {
            ArrayList list = new ArrayList();
            otherMap.forEach((key, value) -> list.add(String.format("%s=%s", key, value)));
            return String.join((CharSequence)"&", list);
        }
        return null;
    }
}

