/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.redshift.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.redshift.param.RedshiftAuthMode;
import org.apache.dolphinscheduler.plugin.datasource.redshift.param.RedshiftConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.redshift.param.RedshiftDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class RedshiftDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, RedshiftDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        RedshiftConnectionParam connectionParams = (RedshiftConnectionParam)this.createConnectionParams(connectionJson);
        String[] hostSeperator = connectionParams.getAddress().split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        RedshiftDataSourceParamDTO redshiftDatasourceParamDTO = new RedshiftDataSourceParamDTO();
        redshiftDatasourceParamDTO.setMode(connectionParams.getMode());
        redshiftDatasourceParamDTO.setDbUser(connectionParams.getDbUser());
        if (connectionParams.getMode().equals((Object)RedshiftAuthMode.PASSWORD)) {
            redshiftDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
            redshiftDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        } else if (hostPortArray[0].contains(":")) {
            String portString = hostPortArray[0].split(":")[1];
            if (StringUtils.isNumeric((CharSequence)portString)) {
                redshiftDatasourceParamDTO.setPort(Integer.parseInt(portString));
                redshiftDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
            } else {
                redshiftDatasourceParamDTO.setHost(hostPortArray[0]);
            }
        } else {
            redshiftDatasourceParamDTO.setHost(hostPortArray[0]);
        }
        redshiftDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        redshiftDatasourceParamDTO.setUserName(connectionParams.getUser());
        redshiftDatasourceParamDTO.setOther(connectionParams.getOther());
        return redshiftDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        RedshiftDataSourceParamDTO redshiftParam = (RedshiftDataSourceParamDTO)datasourceParam;
        String address = this.getAddress(redshiftParam);
        String jdbcUrl = address + "/" + redshiftParam.getDatabase();
        RedshiftConnectionParam redshiftConnectionParam = new RedshiftConnectionParam();
        redshiftConnectionParam.setUser(redshiftParam.getUserName());
        redshiftConnectionParam.setPassword(PasswordUtils.encodePassword((String)redshiftParam.getPassword()));
        redshiftConnectionParam.setOther(redshiftParam.getOther());
        redshiftConnectionParam.setAddress(address);
        redshiftConnectionParam.setJdbcUrl(jdbcUrl);
        redshiftConnectionParam.setDatabase(redshiftParam.getDatabase());
        redshiftConnectionParam.setDriverClassName(this.getDatasourceDriver());
        redshiftConnectionParam.setValidationQuery(this.getValidationQuery());
        redshiftConnectionParam.setMode(redshiftParam.getMode());
        redshiftConnectionParam.setDbUser(redshiftParam.getDbUser());
        return redshiftConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, RedshiftConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.amazon.redshift.jdbc42.Driver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        RedshiftConnectionParam redshiftConnectionParam = (RedshiftConnectionParam)connectionParam;
        if (MapUtils.isNotEmpty((Map)redshiftConnectionParam.getOther())) {
            return String.format("%s?%s", redshiftConnectionParam.getJdbcUrl(), RedshiftDataSourceProcessor.transformOther(redshiftConnectionParam.getOther()));
        }
        return redshiftConnectionParam.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        RedshiftConnectionParam redshiftConnectionParam = (RedshiftConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        if (redshiftConnectionParam.getMode().equals((Object)RedshiftAuthMode.PASSWORD)) {
            return DriverManager.getConnection(this.getJdbcUrl(connectionParam), redshiftConnectionParam.getUser(), PasswordUtils.decodePassword((String)redshiftConnectionParam.getPassword()));
        }
        if (redshiftConnectionParam.getMode().equals((Object)RedshiftAuthMode.IAM_ACCESS_KEY)) {
            return RedshiftDataSourceProcessor.getConnectionByIAM(redshiftConnectionParam);
        }
        return null;
    }

    public DbType getDbType() {
        return DbType.REDSHIFT;
    }

    public DataSourceProcessor create() {
        return new RedshiftDataSourceProcessor();
    }

    private String getAddress(RedshiftDataSourceParamDTO redshiftParam) {
        if (redshiftParam.getMode().equals((Object)RedshiftAuthMode.PASSWORD)) {
            return String.format("%s%s:%s", "jdbc:redshift://", redshiftParam.getHost(), redshiftParam.getPort());
        }
        if (redshiftParam.getMode().equals((Object)RedshiftAuthMode.IAM_ACCESS_KEY)) {
            if (redshiftParam.getPort() == null) {
                return String.format("%s%s", "jdbc:redshift:iam://", redshiftParam.getHost());
            }
            return String.format("%s%s:%s", "jdbc:redshift:iam://", redshiftParam.getHost(), redshiftParam.getPort());
        }
        return null;
    }

    private static String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isNotEmpty(otherMap)) {
            ArrayList list = new ArrayList(otherMap.size());
            otherMap.forEach((key, value) -> list.add(String.format("%s=%s", key, value)));
            return String.join((CharSequence)";", list);
        }
        return null;
    }

    public static Connection getConnectionByIAM(RedshiftConnectionParam redshiftConnectionParam) {
        String connectionUrl;
        String authParams = String.format("AccessKeyID=%s&SecretAccessKey=%s&DbUser=%s", redshiftConnectionParam.getUser(), PasswordUtils.decodePassword((String)redshiftConnectionParam.getPassword()), redshiftConnectionParam.getDbUser());
        if (MapUtils.isNotEmpty((Map)redshiftConnectionParam.getOther())) {
            String basic = String.format("%s?%s", redshiftConnectionParam.getJdbcUrl(), RedshiftDataSourceProcessor.transformOther(redshiftConnectionParam.getOther()));
            connectionUrl = String.format("%s&%s", basic, authParams);
        } else {
            String basic = redshiftConnectionParam.getJdbcUrl();
            connectionUrl = String.format("%s?%s", basic, authParams);
        }
        try {
            Class.forName("com.amazon.redshift.jdbc42.Driver");
            return DriverManager.getConnection(connectionUrl);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

