/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.kyuubi.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.kyuubi.param.KyuubiConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.kyuubi.param.KyuubiDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class KyuubiDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, KyuubiDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        String[] hostPortArray;
        KyuubiDataSourceParamDTO kyuubiDataSourceParamDTO = new KyuubiDataSourceParamDTO();
        KyuubiConnectionParam kyuubiConnectionParam = (KyuubiConnectionParam)this.createConnectionParams(connectionJson);
        kyuubiDataSourceParamDTO.setDatabase(kyuubiConnectionParam.getDatabase());
        kyuubiDataSourceParamDTO.setUserName(kyuubiConnectionParam.getUser());
        kyuubiDataSourceParamDTO.setOther(kyuubiConnectionParam.getOther());
        String[] tmpArray = kyuubiConnectionParam.getAddress().split("//");
        StringBuilder hosts = new StringBuilder();
        for (String hostPort : hostPortArray = tmpArray[tmpArray.length - 1].split(",")) {
            hosts.append(hostPort.split(":")[0]).append(",");
        }
        hosts.deleteCharAt(hosts.length() - 1);
        kyuubiDataSourceParamDTO.setHost(hosts.toString());
        kyuubiDataSourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        return kyuubiDataSourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        KyuubiDataSourceParamDTO kyuubiParam = (KyuubiDataSourceParamDTO)datasourceParam;
        StringBuilder address = new StringBuilder();
        address.append("jdbc:kyuubi://");
        for (String zkHost : kyuubiParam.getHost().split(",")) {
            address.append(String.format("%s:%s,", zkHost, kyuubiParam.getPort()));
        }
        address.deleteCharAt(address.length() - 1);
        String jdbcUrl = address + "/" + kyuubiParam.getDatabase();
        KyuubiConnectionParam kyuubiConnectionParam = new KyuubiConnectionParam();
        kyuubiConnectionParam.setDatabase(kyuubiParam.getDatabase());
        kyuubiConnectionParam.setAddress(address.toString());
        kyuubiConnectionParam.setJdbcUrl(jdbcUrl);
        kyuubiConnectionParam.setUser(kyuubiParam.getUserName());
        kyuubiConnectionParam.setPassword(PasswordUtils.encodePassword((String)kyuubiParam.getPassword()));
        kyuubiConnectionParam.setDriverClassName(this.getDatasourceDriver());
        kyuubiConnectionParam.setValidationQuery(this.getValidationQuery());
        kyuubiConnectionParam.setOther(kyuubiParam.getOther());
        return kyuubiConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, KyuubiConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "org.apache.kyuubi.jdbc.KyuubiHiveDriver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        KyuubiConnectionParam kyuubiConnectionParam = (KyuubiConnectionParam)connectionParam;
        String jdbcUrl = kyuubiConnectionParam.getJdbcUrl();
        if (MapUtils.isNotEmpty((Map)kyuubiConnectionParam.getOther())) {
            return jdbcUrl + ";" + this.transformOther(kyuubiConnectionParam.getOther());
        }
        return jdbcUrl;
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        KyuubiConnectionParam kyuubiConnectionParam = (KyuubiConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), kyuubiConnectionParam.getUser(), PasswordUtils.decodePassword((String)kyuubiConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.KYUUBI;
    }

    public DataSourceProcessor create() {
        return new KyuubiDataSourceProcessor();
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        ArrayList otherList = new ArrayList();
        otherMap.forEach((key, value) -> otherList.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)";", otherList);
    }
}

