/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstanceRelation;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceRelationMapper;
import org.apache.dolphinscheduler.dao.repository.BaseDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.model.DateInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class WorkflowInstanceDaoImpl
extends BaseDao<WorkflowInstance, WorkflowInstanceMapper>
implements WorkflowInstanceDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceDaoImpl.class);
    @Autowired
    private WorkflowInstanceRelationMapper workflowInstanceRelationMapper;

    public WorkflowInstanceDaoImpl(@NonNull WorkflowInstanceMapper workflowInstanceMapper) {
        super(workflowInstanceMapper);
        if (workflowInstanceMapper == null) {
            throw new NullPointerException("workflowInstanceMapper is marked non-null but is null");
        }
    }

    @Override
    public void upsertWorkflowInstance(@NonNull WorkflowInstance workflowInstance) {
        if (workflowInstance == null) {
            throw new NullPointerException("workflowInstance is marked non-null but is null");
        }
        if (workflowInstance.getId() != null) {
            this.updateById(workflowInstance);
        } else {
            this.insert(workflowInstance);
        }
    }

    @Override
    public void updateWorkflowInstanceState(Integer workflowInstanceId, WorkflowExecutionStatus originalStatus, WorkflowExecutionStatus targetStatus) {
        int update = ((WorkflowInstanceMapper)this.mybatisMapper).updateWorkflowInstanceState(workflowInstanceId, originalStatus, targetStatus);
        if (update != 1) {
            WorkflowInstance workflowInstance = (WorkflowInstance)((WorkflowInstanceMapper)this.mybatisMapper).selectById(workflowInstanceId);
            if (workflowInstance == null) {
                throw new UnsupportedOperationException("updateWorkflowInstance " + workflowInstanceId + " state failed, the workflow instance is not exist in db");
            }
            throw new UnsupportedOperationException("updateWorkflowInstance " + workflowInstanceId + " state failed, expect original state is " + originalStatus.name() + " actual state is : {} " + workflowInstance.getState().name());
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void performTransactionalUpsert(WorkflowInstance workflowInstance) {
        this.upsertWorkflowInstance(workflowInstance);
    }

    @Override
    public WorkflowInstance queryLastSchedulerWorkflowInterval(Long workflowDefinitionCode, Long taskDefinitionCode, DateInterval dateInterval) {
        return ((WorkflowInstanceMapper)this.mybatisMapper).queryLastSchedulerWorkflow(workflowDefinitionCode, taskDefinitionCode, dateInterval.getStartTime(), dateInterval.getEndTime());
    }

    @Override
    public WorkflowInstance queryLastManualWorkflowInterval(Long definitionCode, Long taskCode, DateInterval dateInterval) {
        return ((WorkflowInstanceMapper)this.mybatisMapper).queryLastManualWorkflow(definitionCode, taskCode, dateInterval.getStartTime(), dateInterval.getEndTime());
    }

    @Override
    public WorkflowInstance queryLastRunningWorkflowInterval(Long definitionCode, DateInterval dateInterval) {
        int[] runningStateArray = new int[]{WorkflowExecutionStatus.SUBMITTED_SUCCESS.ordinal(), WorkflowExecutionStatus.RUNNING_EXECUTION.ordinal(), WorkflowExecutionStatus.READY_PAUSE.ordinal(), WorkflowExecutionStatus.READY_STOP.ordinal()};
        return ((WorkflowInstanceMapper)this.mybatisMapper).queryLastRunningWorkflow(definitionCode, dateInterval.getStartTime(), dateInterval.getEndTime(), runningStateArray);
    }

    @Override
    public WorkflowInstance queryFirstScheduleWorkflowInstance(Long definitionCode) {
        return ((WorkflowInstanceMapper)this.mybatisMapper).queryFirstScheduleWorkflowInstance(definitionCode);
    }

    @Override
    public WorkflowInstance queryFirstStartWorkflowInstance(Long definitionCode) {
        return ((WorkflowInstanceMapper)this.mybatisMapper).queryFirstStartWorkflowInstance(definitionCode);
    }

    @Override
    public WorkflowInstance querySubWorkflowInstanceByParentId(Integer workflowInstanceId, Integer taskInstanceId) {
        WorkflowInstance workflowInstance = null;
        WorkflowInstanceRelation workflowInstanceRelation = this.workflowInstanceRelationMapper.queryByParentId(workflowInstanceId, taskInstanceId);
        if (workflowInstanceRelation == null || workflowInstanceRelation.getWorkflowInstanceId() == 0) {
            return workflowInstance;
        }
        workflowInstance = (WorkflowInstance)this.queryById(Integer.valueOf(workflowInstanceRelation.getWorkflowInstanceId()));
        return workflowInstance;
    }

    @Override
    public List<WorkflowInstance> queryByWorkflowCodeVersionStatus(Long workflowDefinitionCode, int workflowDefinitionVersion, int[] states) {
        return ((WorkflowInstanceMapper)this.mybatisMapper).queryByWorkflowCodeVersionStatus(workflowDefinitionCode, workflowDefinitionVersion, states);
    }

    @Override
    public List<String> queryNeedFailoverMasters() {
        return ((WorkflowInstanceMapper)this.mybatisMapper).queryNeedFailoverWorkflowInstanceHost(WorkflowExecutionStatus.getNeedFailoverWorkflowInstanceState());
    }

    @Override
    public List<WorkflowInstance> queryNeedFailoverWorkflowInstances(String masterAddress) {
        return ((WorkflowInstanceMapper)this.mybatisMapper).queryByHostAndStatus(masterAddress, WorkflowExecutionStatus.getNeedFailoverWorkflowInstanceState());
    }
}

