/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.plugin.mysql.monitor;

import com.baomidou.mybatisplus.annotation.DbType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMetrics;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMonitor;

public class MysqlMonitor
implements DatabaseMonitor {
    private final DataSource dataSource;

    public MysqlMonitor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DatabaseMetrics getDatabaseMetrics() {
        DatabaseMetrics monitorRecord = new DatabaseMetrics();
        monitorRecord.setDate(new Date());
        monitorRecord.setDbType(DbType.MYSQL);
        monitorRecord.setState(DatabaseMetrics.DatabaseHealthStatus.YES);
        try (Connection connection = this.dataSource.getConnection();
             Statement pstmt = connection.createStatement();){
            try (ResultSet rs1 = pstmt.executeQuery("show global variables");){
                while (rs1.next()) {
                    if (!"MAX_CONNECTIONS".equalsIgnoreCase(rs1.getString("variable_name"))) continue;
                    monitorRecord.setMaxConnections(Long.parseLong(rs1.getString("value")));
                }
            }
            var7_12 = null;
            try (ResultSet rs2 = pstmt.executeQuery("show global status");){
                while (rs2.next()) {
                    if ("MAX_USED_CONNECTIONS".equalsIgnoreCase(rs2.getString("variable_name"))) {
                        monitorRecord.setMaxUsedConnections(Long.parseLong(rs2.getString("value")));
                        continue;
                    }
                    if ("THREADS_CONNECTED".equalsIgnoreCase(rs2.getString("variable_name"))) {
                        monitorRecord.setThreadsConnections(Long.parseLong(rs2.getString("value")));
                        continue;
                    }
                    if (!"THREADS_RUNNING".equalsIgnoreCase(rs2.getString("variable_name"))) continue;
                    monitorRecord.setThreadsRunningConnections(Long.parseLong(rs2.getString("value")));
                }
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
        }
        return monitorRecord;
    }
}

