/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.SetUtils;

public class MapComparator<K, V> {
    private final Map<K, V> oldMap;
    private final Map<K, V> newMap;

    public MapComparator(Map<K, V> oldMap, Map<K, V> newMap) {
        this.oldMap = oldMap;
        this.newMap = newMap;
    }

    public Set<K> getKeysToAdd() {
        if (MapUtils.isEmpty(this.newMap)) {
            return SetUtils.emptySet();
        }
        if (MapUtils.isEmpty(this.oldMap)) {
            return new HashSet<K>(this.newMap.keySet());
        }
        HashSet<K> keysToAdd = new HashSet<K>(this.newMap.keySet());
        keysToAdd.removeAll(this.oldMap.keySet());
        return keysToAdd;
    }

    public List<V> getValuesToAdd() {
        if (MapUtils.isEmpty(this.newMap)) {
            return Collections.emptyList();
        }
        return this.getKeysToAdd().stream().map(this.newMap::get).collect(Collectors.toList());
    }

    public Set<K> getKeysToRemove() {
        if (MapUtils.isEmpty(this.oldMap)) {
            return SetUtils.emptySet();
        }
        if (MapUtils.isEmpty(this.newMap)) {
            return new HashSet<K>(this.oldMap.keySet());
        }
        HashSet<K> keysToRemove = new HashSet<K>(this.oldMap.keySet());
        keysToRemove.removeAll(this.newMap.keySet());
        return keysToRemove;
    }

    public List<V> getValuesToRemove() {
        if (MapUtils.isEmpty(this.oldMap)) {
            return Collections.emptyList();
        }
        return this.getKeysToRemove().stream().map(this.oldMap::get).collect(Collectors.toList());
    }

    public Set<K> getKeysToUpdate() {
        if (MapUtils.isEmpty(this.oldMap) || MapUtils.isEmpty(this.newMap)) {
            return SetUtils.emptySet();
        }
        HashSet<K> keysToUpdate = new HashSet<K>(this.newMap.keySet());
        keysToUpdate.retainAll(this.oldMap.keySet());
        keysToUpdate.removeIf(key -> this.newMap.get(key).equals(this.oldMap.get(key)));
        return keysToUpdate;
    }

    public List<V> getNewValuesToUpdate() {
        if (MapUtils.isEmpty(this.oldMap) || MapUtils.isEmpty(this.newMap)) {
            return Collections.emptyList();
        }
        return this.getKeysToUpdate().stream().map(this.newMap::get).collect(Collectors.toList());
    }

    @Generated
    public Map<K, V> getOldMap() {
        return this.oldMap;
    }

    @Generated
    public Map<K, V> getNewMap() {
        return this.newMap;
    }

    @Generated
    public String toString() {
        return "MapComparator(oldMap=" + this.getOldMap() + ", newMap=" + this.getNewMap() + ")";
    }
}

