/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.sql.ClasspathSqlScriptParser;
import org.apache.dolphinscheduler.common.sql.SqlScriptParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlScriptRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlScriptRunner.class);
    private final DataSource dataSource;
    private final SqlScriptParser sqlScriptParser;

    public SqlScriptRunner(DataSource dataSource, String sqlScriptFilePath) {
        this.dataSource = dataSource;
        this.sqlScriptParser = new ClasspathSqlScriptParser(sqlScriptFilePath);
    }

    public void execute() throws SQLException, IOException {
        List<String> allSql = this.sqlScriptParser.getAllSql();
        try (Connection connection = this.dataSource.getConnection();){
            for (String sql : allSql) {
                if (StringUtils.isBlank((CharSequence)sql)) continue;
                Statement statement = connection.createStatement();
                Throwable throwable = null;
                try {
                    statement.execute(sql);
                    log.info("Execute sql: {} success", (Object)sql);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
    }
}

