/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.DynamicSubWorkflowDto;
import org.apache.dolphinscheduler.api.dto.gantt.GanttDto;
import org.apache.dolphinscheduler.api.dto.gantt.Task;
import org.apache.dolphinscheduler.api.dto.workflowInstance.WorkflowInstanceQueryRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.LoggerService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskInstanceService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.service.WorkflowDefinitionService;
import org.apache.dolphinscheduler.api.service.WorkflowInstanceService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ContextType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.AbstractTaskInstanceContext;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.RelationSubWorkflow;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstanceContext;
import org.apache.dolphinscheduler.dao.entity.TaskInstanceDependentDetails;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelationLog;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.RelationSubWorkflowMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceMapper;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceContextDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceMapDao;
import org.apache.dolphinscheduler.dao.utils.WorkflowUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.TaskTypeUtils;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkflowInstanceServiceImpl
extends BaseServiceImpl
implements WorkflowInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceServiceImpl.class);
    public static final String TASK_TYPE = "taskType";
    public static final String LOCAL_PARAMS_LIST = "localParamsList";
    @Autowired
    ProjectMapper projectMapper;
    @Autowired
    ProjectService projectService;
    @Autowired
    ProcessService processService;
    @Autowired
    TaskInstanceDao taskInstanceDao;
    @Lazy
    @Autowired
    private TaskInstanceService taskInstanceService;
    @Autowired
    WorkflowInstanceMapper workflowInstanceMapper;
    @Autowired
    WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private WorkflowInstanceMapDao workflowInstanceMapDao;
    @Autowired
    WorkflowDefinitionMapper workflowDefinitionMapper;
    @Autowired
    WorkflowDefinitionService workflowDefinitionService;
    @Autowired
    ExecutorService execService;
    @Autowired
    TaskInstanceMapper taskInstanceMapper;
    @Autowired
    LoggerService loggerService;
    @Autowired
    WorkflowDefinitionLogMapper workflowDefinitionLogMapper;
    @Autowired
    TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    UsersService usersService;
    @Autowired
    TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private RelationSubWorkflowMapper relationSubWorkflowMapper;
    @Autowired
    private AlertDao alertDao;
    @Autowired
    private CuringParamsService curingGlobalParamsService;
    @Autowired
    private TaskInstanceContextDao taskInstanceContextDao;

    @Override
    public Map<String, Object> queryTopNLongestRunningWorkflowInstance(User loginUser, long projectCode, int size, String startTime, String endTime) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (0 > size) {
            this.putMsg(result, Status.NEGTIVE_SIZE_NUMBER_ERROR, size);
            return result;
        }
        if (Objects.isNull(startTime)) {
            this.putMsg(result, Status.DATA_IS_NULL, "start time");
            return result;
        }
        Date start = DateUtils.stringToDate((String)startTime);
        if (Objects.isNull(endTime)) {
            this.putMsg(result, Status.DATA_IS_NULL, "end time");
            return result;
        }
        Date end = DateUtils.stringToDate((String)endTime);
        if (start == null || end == null) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
            return result;
        }
        if (start.getTime() > end.getTime()) {
            this.putMsg(result, Status.START_TIME_BIGGER_THAN_END_TIME_ERROR, startTime, endTime);
            return result;
        }
        List workflowInstances = this.workflowInstanceMapper.queryTopNWorkflowInstance(size, start, end, WorkflowExecutionStatus.SUCCESS, projectCode);
        result.put("data", workflowInstances);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryWorkflowInstanceById(User loginUser, long projectCode, Integer workflowInstanceId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowInstance workflowInstance = (WorkflowInstance)this.processService.findWorkflowInstanceDetailById(workflowInstanceId.intValue()).orElseThrow(() -> new ServiceException(Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId));
        WorkflowDefinition workflowDefinition = this.processService.findWorkflowDefinition(workflowInstance.getWorkflowDefinitionCode(), workflowInstance.getWorkflowDefinitionVersion());
        if (workflowDefinition == null || projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, projectCode: {}.", (Object)projectCode);
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, workflowInstanceId);
        } else {
            workflowInstance.setLocations(workflowDefinition.getLocations());
            workflowInstance.setDagData(this.processService.genDagData(workflowDefinition));
            result.put("data", workflowInstance);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public WorkflowInstance queryByWorkflowInstanceIdThrowExceptionIfNotFound(Integer workflowInstanceId) {
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryById((Serializable)workflowInstanceId);
        if (workflowInstance == null) {
            throw new ServiceException(Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId);
        }
        return workflowInstance;
    }

    @Override
    public Map<String, Object> queryWorkflowInstanceById(User loginUser, Integer workflowInstanceId) {
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceMapper.selectById((Serializable)workflowInstanceId);
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowInstance.getWorkflowDefinitionCode().longValue());
        return this.queryWorkflowInstanceById(loginUser, workflowDefinition.getProjectCode(), workflowInstanceId);
    }

    @Override
    public Result<PageInfo<WorkflowInstance>> queryWorkflowInstanceList(User loginUser, long projectCode, long workflowDefinitionCode, String startDate, String endDate, String searchVal, String executorName, WorkflowExecutionStatus stateType, String host, String otherParamsJson, Integer pageNo, Integer pageSize) {
        Result<PageInfo<WorkflowInstance>> result = new Result<PageInfo<WorkflowInstance>>();
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:process-instance:list");
        int[] statusArray = null;
        if (stateType != null) {
            statusArray = new int[]{stateType.getCode()};
        }
        Date start = this.checkAndParseDateParameters(startDate);
        Date end = this.checkAndParseDateParameters(endDate);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        IPage workflowInstanceList = this.workflowInstanceMapper.queryWorkflowInstanceListPaging(page, Long.valueOf(projectCode), Long.valueOf(workflowDefinitionCode), searchVal, executorName, statusArray, host, start, end);
        List workflowInstances = workflowInstanceList.getRecords();
        List<Integer> userIds = Collections.emptyList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)workflowInstances)) {
            userIds = workflowInstances.stream().map(WorkflowInstance::getExecutorId).collect(Collectors.toList());
        }
        List<User> users = this.usersService.queryUser(userIds);
        Map<Object, Object> idToUserMap = Collections.emptyMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(users)) {
            idToUserMap = users.stream().collect(Collectors.toMap(User::getId, Function.identity()));
        }
        for (WorkflowInstance workflowInstance : workflowInstances) {
            workflowInstance.setDuration(WorkflowUtils.getWorkflowInstanceDuration((WorkflowInstance)workflowInstance));
            User executor = (User)idToUserMap.get(workflowInstance.getExecutorId());
            if (null == executor) continue;
            workflowInstance.setExecutorName(executor.getUserName());
        }
        pageInfo.setTotal((int)workflowInstanceList.getTotal());
        pageInfo.setTotalList(workflowInstances);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result queryWorkflowInstanceList(User loginUser, WorkflowInstanceQueryRequest workflowInstanceQueryRequest) {
        Result result = new Result();
        WorkflowInstance workflowInstance = workflowInstanceQueryRequest.convert2WorkflowInstance();
        String projectName = workflowInstanceQueryRequest.getProjectName();
        if (!StringUtils.isBlank((CharSequence)projectName)) {
            Project project = this.projectMapper.queryByName(projectName);
            this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:definition:list");
            WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByDefineName(project.getCode(), workflowInstance.getName());
            workflowInstance.setWorkflowDefinitionCode(Long.valueOf(workflowDefinition.getCode()));
            workflowInstance.setProjectCode(Long.valueOf(project.getCode()));
        }
        Page page = new Page((long)workflowInstanceQueryRequest.getPageNo().intValue(), (long)workflowInstanceQueryRequest.getPageSize().intValue());
        PageInfo pageInfo = new PageInfo(workflowInstanceQueryRequest.getPageNo(), workflowInstanceQueryRequest.getPageSize());
        IPage workflowInstanceList = this.workflowInstanceMapper.queryWorkflowInstanceListV2Paging(page, workflowInstance.getProjectCode(), workflowInstance.getWorkflowDefinitionCode(), workflowInstance.getName(), workflowInstanceQueryRequest.getStartTime(), workflowInstanceQueryRequest.getEndTime(), workflowInstanceQueryRequest.getState(), workflowInstance.getHost());
        List workflowInstances = workflowInstanceList.getRecords();
        List<Integer> userIds = Collections.emptyList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)workflowInstances)) {
            userIds = workflowInstances.stream().map(WorkflowInstance::getExecutorId).collect(Collectors.toList());
        }
        List<User> users = this.usersService.queryUser(userIds);
        Map<Object, Object> idToUserMap = Collections.emptyMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(users)) {
            idToUserMap = users.stream().collect(Collectors.toMap(User::getId, Function.identity()));
        }
        for (WorkflowInstance Instance2 : workflowInstances) {
            Instance2.setDuration(WorkflowUtils.getWorkflowInstanceDuration((WorkflowInstance)Instance2));
            User executor = (User)idToUserMap.get(Instance2.getExecutorId());
            if (null == executor) continue;
            Instance2.setExecutorName(executor.getUserName());
        }
        pageInfo.setTotal((int)workflowInstanceList.getTotal());
        pageInfo.setTotalList(workflowInstances);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryTaskListByWorkflowInstanceId(User loginUser, long projectCode, Integer workflowInstanceId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowInstance workflowInstance = (WorkflowInstance)this.processService.findWorkflowInstanceDetailById(workflowInstanceId.intValue()).orElseThrow(() -> new ServiceException(Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId));
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowInstance.getWorkflowDefinitionCode().longValue());
        if (workflowDefinition != null && projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, projectCode:{}, workflowInstanceId:{}.", (Object)projectCode, (Object)workflowInstanceId);
            this.putMsg(result, Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId);
            return result;
        }
        List taskInstanceList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(workflowInstanceId);
        List<TaskInstanceDependentDetails<AbstractTaskInstanceContext>> taskInstanceDependentDetailsList = this.setTaskInstanceDependentResult(taskInstanceList);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("workflowInstanceState", workflowInstance.getState().toString());
        resultMap.put("taskList", taskInstanceDependentDetailsList);
        result.put("data", resultMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<TaskInstanceDependentDetails<AbstractTaskInstanceContext>> setTaskInstanceDependentResult(List<TaskInstance> taskInstanceList) {
        List<TaskInstanceDependentDetails<AbstractTaskInstanceContext>> taskInstanceDependentDetailsList = taskInstanceList.stream().map(taskInstance -> {
            TaskInstanceDependentDetails taskInstanceDependentDetails = new TaskInstanceDependentDetails();
            BeanUtils.copyProperties((Object)taskInstance, (Object)taskInstanceDependentDetails);
            return taskInstanceDependentDetails;
        }).collect(Collectors.toList());
        List taskInstanceIdList = taskInstanceList.stream().map(TaskInstance::getId).collect(Collectors.toList());
        List taskInstanceContextList = this.taskInstanceContextDao.batchQueryByTaskInstanceIdsAndContextType(taskInstanceIdList, ContextType.DEPENDENT_RESULT_CONTEXT);
        for (TaskInstanceContext taskInstanceContext : taskInstanceContextList) {
            for (TaskInstanceDependentDetails<AbstractTaskInstanceContext> taskInstanceDependentDetails : taskInstanceDependentDetailsList) {
                if (!taskInstanceDependentDetails.getId().equals(taskInstanceContext.getTaskInstanceId())) continue;
                taskInstanceDependentDetails.setTaskInstanceDependentResults(taskInstanceContext.getTaskInstanceContext());
            }
        }
        return taskInstanceDependentDetailsList;
    }

    @Override
    public List<DynamicSubWorkflowDto> queryDynamicSubWorkflowInstances(User loginUser, Integer taskId) {
        int subWorkflowVersion;
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)taskId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (taskInstance == null) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            throw new ServiceException(Status.TASK_INSTANCE_NOT_EXISTS, taskId);
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskInstance.getTaskCode());
        if (taskDefinition == null) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            throw new ServiceException(Status.TASK_INSTANCE_NOT_EXISTS, taskId);
        }
        List relationSubWorkflows = this.relationSubWorkflowMapper.queryAllSubWorkflowInstance(Long.valueOf(taskInstance.getWorkflowInstanceId()), Long.valueOf(taskInstance.getTaskCode()));
        List allSubWorkflowInstanceId = relationSubWorkflows.stream().map(RelationSubWorkflow::getSubWorkflowInstanceId).collect(Collectors.toList());
        List allSubWorkflows = this.workflowInstanceDao.queryByIds(allSubWorkflowInstanceId);
        if (allSubWorkflows == null || allSubWorkflows.isEmpty()) {
            this.putMsg(result, Status.SUB_WORKFLOW_INSTANCE_NOT_EXIST, taskId);
            throw new ServiceException(Status.SUB_WORKFLOW_INSTANCE_NOT_EXIST, taskId);
        }
        Long subWorkflowCode = ((WorkflowInstance)allSubWorkflows.get(0)).getWorkflowDefinitionCode();
        WorkflowDefinition subWorkflowDefinition = this.processService.findWorkflowDefinition(subWorkflowCode, subWorkflowVersion = ((WorkflowInstance)allSubWorkflows.get(0)).getWorkflowDefinitionVersion());
        if (subWorkflowDefinition == null) {
            this.putMsg(result, Status.WORKFLOW_DEFINITION_NOT_EXIST, subWorkflowCode);
            throw new ServiceException(Status.WORKFLOW_DEFINITION_NOT_EXIST, subWorkflowCode);
        }
        allSubWorkflows.sort(Comparator.comparing(WorkflowInstance::getId));
        ArrayList<DynamicSubWorkflowDto> allDynamicSubWorkflowDtos = new ArrayList<DynamicSubWorkflowDto>();
        int index = 1;
        for (WorkflowInstance workflowInstance : allSubWorkflows) {
            DynamicSubWorkflowDto dynamicSubWorkflowDto = new DynamicSubWorkflowDto();
            dynamicSubWorkflowDto.setWorkflowInstanceId(workflowInstance.getId().intValue());
            dynamicSubWorkflowDto.setIndex(index);
            dynamicSubWorkflowDto.setState(workflowInstance.getState());
            dynamicSubWorkflowDto.setName(subWorkflowDefinition.getName());
            Map commandParamMap = JSONUtils.toMap((String)workflowInstance.getCommandParam());
            String parameter = (String)commandParamMap.get("dynamicParams");
            dynamicSubWorkflowDto.setParameters(JSONUtils.toMap((String)parameter));
            allDynamicSubWorkflowDtos.add(dynamicSubWorkflowDto);
            ++index;
        }
        return allDynamicSubWorkflowDtos;
    }

    @Override
    public Map<String, Object> querySubWorkflowInstanceByTaskId(User loginUser, long projectCode, Integer taskId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)taskId);
        if (taskInstance == null) {
            log.error("Task instance does not exist, projectCode:{}, taskInstanceId{}.", (Object)projectCode, (Object)taskId);
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskInstance.getTaskCode());
        if (taskDefinition != null && projectCode != taskDefinition.getProjectCode()) {
            log.error("Task definition does not exist, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskInstance.getTaskCode());
            this.putMsg(result, Status.TASK_INSTANCE_NOT_EXISTS, taskId);
            return result;
        }
        if (!TaskTypeUtils.isSubWorkflowTask((String)taskInstance.getTaskType())) {
            this.putMsg(result, Status.TASK_INSTANCE_NOT_SUB_WORKFLOW_INSTANCE, taskInstance.getName());
            return result;
        }
        WorkflowInstance subWorkflowInstance = this.processService.findSubWorkflowInstance(Integer.valueOf(taskInstance.getWorkflowInstanceId()), taskInstance.getId());
        if (subWorkflowInstance == null) {
            log.error("Sub workflow instance does not exist, projectCode:{}, taskInstanceId:{}.", (Object)projectCode, (Object)taskInstance.getId());
            this.putMsg(result, Status.SUB_WORKFLOW_INSTANCE_NOT_EXIST, taskId);
            return result;
        }
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("subWorkflowInstanceId", subWorkflowInstance.getId());
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> updateWorkflowInstance(User loginUser, long projectCode, Integer workflowInstanceId, String taskRelationJson, String taskDefinitionJson, String scheduleTime, Boolean syncDefine, String globalParams, String locations, int timeout) {
        int insertResult;
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:process-instance:update");
        Map<String, Object> result = new HashMap<String, Object>();
        WorkflowInstance workflowInstance = (WorkflowInstance)this.processService.findWorkflowInstanceDetailById(workflowInstanceId.intValue()).orElseThrow(() -> new ServiceException(Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId));
        WorkflowDefinition workflowDefinition0 = this.workflowDefinitionMapper.queryByCode(workflowInstance.getWorkflowDefinitionCode().longValue());
        if (workflowDefinition0 != null && projectCode != workflowDefinition0.getProjectCode()) {
            log.error("workflow definition does not exist, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)workflowInstance.getWorkflowDefinitionCode());
            this.putMsg(result, Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId);
            return result;
        }
        if (!workflowInstance.getState().isFinished()) {
            log.warn("workflow Instance state is {} so can not update workflow instance, workflowInstanceId:{}.", (Object)workflowInstance.getState().getDesc(), (Object)workflowInstanceId);
            this.putMsg(result, Status.WORKFLOW_INSTANCE_STATE_OPERATION_ERROR, workflowInstance.getName(), workflowInstance.getState().toString(), "update");
            return result;
        }
        Map commandParamMap = JSONUtils.toMap((String)workflowInstance.getCommandParam());
        String timezoneId = null;
        timezoneId = commandParamMap == null || StringUtils.isBlank((CharSequence)((CharSequence)commandParamMap.get("schedule_timezone"))) ? loginUser.getTimeZone() : (String)commandParamMap.get("schedule_timezone");
        this.setWorkflowInstance(workflowInstance, scheduleTime, globalParams, timeout, timezoneId);
        List taskDefinitionLogs = JSONUtils.toList((String)taskDefinitionJson, TaskDefinitionLog.class);
        if (taskDefinitionLogs.isEmpty()) {
            log.warn("Parameter taskDefinitionJson is empty");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJson);
            return result;
        }
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            if (TaskPluginManager.checkTaskParameters((String)taskDefinitionLog.getTaskType(), (String)taskDefinitionLog.getTaskParams())) continue;
            log.error("Task parameters are invalid,  taskDefinitionName:{}.", (Object)taskDefinitionLog.getName());
            this.putMsg(result, Status.WORKFLOW_NODE_S_PARAMETER_INVALID, taskDefinitionLog.getName());
            return result;
        }
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, projectCode, taskDefinitionLogs, syncDefine);
        if (saveTaskResult == -1) {
            log.error("Update task definition error, projectCode:{}, workflowInstanceId:{}", (Object)projectCode, (Object)workflowInstanceId);
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowInstance.getWorkflowDefinitionCode().longValue());
        List taskRelationList = JSONUtils.toList((String)taskRelationJson, WorkflowTaskRelationLog.class);
        result = this.workflowDefinitionService.checkWorkflowNodeList(taskRelationJson, taskDefinitionLogs);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        workflowDefinition.set(projectCode, workflowDefinition.getName(), workflowDefinition.getDescription(), globalParams, locations, timeout);
        workflowDefinition.setUpdateTime(new Date());
        int insertVersion = this.processService.saveWorkflowDefine(loginUser, workflowDefinition, syncDefine, Boolean.FALSE);
        if (insertVersion == 0) {
            log.error("Update workflow definition error, projectCode:{}, workflowDefinitionName:{}.", (Object)projectCode, (Object)workflowDefinition.getName());
            this.putMsg(result, Status.UPDATE_WORKFLOW_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
        }
        log.info("Update workflow definition complete, projectCode:{}, workflowDefinitionName:{}.", (Object)projectCode, (Object)workflowDefinition.getName());
        if (syncDefine.booleanValue()) {
            this.workflowDefinitionService.saveWorkflowLineage(projectCode, workflowDefinition.getCode(), insertVersion, taskDefinitionLogs);
        }
        if ((insertResult = this.processService.saveTaskRelation(loginUser, workflowDefinition.getProjectCode(), workflowDefinition.getCode(), insertVersion, taskRelationList, taskDefinitionLogs, syncDefine)) != 0) {
            log.info("Update task relations error, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{projectCode, workflowDefinition.getCode(), insertVersion});
            this.putMsg(result, Status.UPDATE_WORKFLOW_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_WORKFLOW_DEFINITION_ERROR);
        }
        log.info("Update task relations complete, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}.", new Object[]{projectCode, workflowDefinition.getCode(), insertVersion});
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", workflowDefinition);
        workflowInstance.setWorkflowDefinitionVersion(insertVersion);
        boolean update = this.workflowInstanceDao.updateById((Object)workflowInstance);
        if (!update) {
            log.error("Update workflow instance version error, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}", new Object[]{projectCode, workflowDefinition.getCode(), insertVersion});
            this.putMsg(result, Status.UPDATE_WORKFLOW_INSTANCE_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_WORKFLOW_INSTANCE_ERROR);
        }
        log.info("Update workflow instance complete, projectCode:{}, workflowDefinitionCode:{}, workflowDefinitionVersion:{}, workflowInstanceId:{}", new Object[]{projectCode, workflowDefinition.getCode(), insertVersion, workflowInstanceId});
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void setWorkflowInstance(WorkflowInstance workflowInstance, String scheduleTime, String globalParams, int timeout, String timezone) {
        Date schedule = workflowInstance.getScheduleTime();
        if (scheduleTime != null) {
            schedule = DateUtils.stringToDate((String)scheduleTime);
        }
        workflowInstance.setScheduleTime(schedule);
        List globalParamList = JSONUtils.toList((String)globalParams, Property.class);
        Map<String, String> globalParamMap = globalParamList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        globalParams = this.curingGlobalParamsService.curingGlobalParams(workflowInstance.getId(), globalParamMap, globalParamList, workflowInstance.getCmdTypeIfComplement(), schedule, timezone);
        workflowInstance.setTimeout(timeout);
        workflowInstance.setGlobalParams(globalParams);
    }

    @Override
    public Map<String, Object> queryParentInstanceBySubId(User loginUser, long projectCode, Integer subId) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        WorkflowInstance subInstance = (WorkflowInstance)this.processService.findWorkflowInstanceDetailById(subId.intValue()).orElseThrow(() -> new ServiceException(Status.WORKFLOW_INSTANCE_NOT_EXIST, subId));
        if (subInstance.getIsSubWorkflow() == Flag.NO) {
            log.warn("workflow instance is not sub workflow instance type, workflowInstanceId:{}, workflowInstanceName:{}.", (Object)subId, (Object)subInstance.getName());
            this.putMsg(result, Status.WORKFLOW_INSTANCE_NOT_SUB_WORKFLOW_INSTANCE, subInstance.getName());
            return result;
        }
        WorkflowInstance parentWorkflowInstance = this.processService.findParentWorkflowInstance(subId);
        if (parentWorkflowInstance == null) {
            log.error("Parent workflow instance does not exist, projectCode:{}, subWorkflowInstanceId:{}.", (Object)projectCode, (Object)subId);
            this.putMsg(result, Status.SUB_WORKFLOW_INSTANCE_NOT_EXIST, new Object[0]);
            return result;
        }
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        dataMap.put("parentWorkflowInstance", parentWorkflowInstance.getId());
        result.put("data", dataMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional
    public void deleteWorkflowInstanceById(User loginUser, Integer workflowInstanceId) {
        WorkflowInstance workflowInstance = (WorkflowInstance)this.processService.findWorkflowInstanceDetailById(workflowInstanceId.intValue()).orElseThrow(() -> new ServiceException(Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId));
        WorkflowDefinitionLog workflowDefinition = this.workflowDefinitionLogMapper.queryByDefinitionCodeAndVersion(workflowInstance.getWorkflowDefinitionCode().longValue(), workflowInstance.getWorkflowDefinitionVersion());
        Project project = this.projectMapper.queryByCode(workflowDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:process-instance:delete");
        if (!workflowInstance.getState().isFinished()) {
            log.warn("workflow Instance state is {} so can not delete workflow instance, workflowInstanceId:{}.", (Object)workflowInstance.getState().getDesc(), (Object)workflowInstanceId);
            throw new ServiceException(Status.WORKFLOW_INSTANCE_STATE_OPERATION_ERROR, workflowInstance.getName(), workflowInstance.getState(), "delete");
        }
        this.deleteWorkflowInstanceById(workflowInstanceId);
    }

    @Override
    public Map<String, Object> viewVariables(long projectCode, Integer workflowInstanceId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkflowInstance workflowInstance = this.workflowInstanceMapper.queryDetailById(workflowInstanceId.intValue());
        if (workflowInstance == null) {
            log.error("workflow instance does not exist, projectCode:{}, workflowInstanceId:{}.", (Object)projectCode, (Object)workflowInstanceId);
            this.putMsg(result, Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId);
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowInstance.getWorkflowDefinitionCode().longValue());
        if (workflowDefinition != null && projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)workflowInstance.getWorkflowDefinitionCode());
            this.putMsg(result, Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId);
            return result;
        }
        Map commandParam = JSONUtils.toMap((String)workflowInstance.getCommandParam());
        String timezone = null;
        if (commandParam != null) {
            timezone = (String)commandParam.get("schedule_timezone");
        }
        Map timeParams = BusinessTimeUtils.getBusinessTime((CommandType)workflowInstance.getCmdTypeIfComplement(), (Date)workflowInstance.getScheduleTime(), (String)timezone);
        String userDefinedParams = workflowInstance.getGlobalParams();
        List globalParams = new ArrayList();
        String globalParamStr = ParameterUtils.convertParameterPlaceholders((String)JSONUtils.toJsonString(globalParams), (Map)timeParams);
        globalParams = JSONUtils.toList((String)globalParamStr, Property.class);
        for (Property property : globalParams) {
            timeParams.put(property.getProp(), property.getValue());
        }
        if (userDefinedParams != null && userDefinedParams.length() > 0) {
            globalParams = JSONUtils.toList((String)userDefinedParams, Property.class);
        }
        Map<String, Map<String, Object>> localUserDefParams = this.getLocalParams(workflowInstance, timeParams);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("globalParams", globalParams);
        resultMap.put("localParams", localUserDefParams);
        result.put("data", resultMap);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private Map<String, Map<String, Object>> getLocalParams(WorkflowInstance workflowInstance, Map<String, String> timeParams) {
        HashMap<String, Map<String, Object>> localUserDefParams = new HashMap<String, Map<String, Object>>();
        List taskInstanceList = this.taskInstanceMapper.findValidTaskListByWorkflowInstanceId(workflowInstance.getId(), Flag.YES);
        for (TaskInstance taskInstance : taskInstanceList) {
            TaskDefinitionLog taskDefinitionLog = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
            String localParams = JSONUtils.getNodeString((String)taskDefinitionLog.getTaskParams(), (String)"localParams");
            if (StringUtils.isEmpty((CharSequence)localParams)) continue;
            localParams = ParameterUtils.convertParameterPlaceholders((String)localParams, timeParams);
            List localParamsList = JSONUtils.toList((String)localParams, Property.class);
            HashMap<String, Object> localParamsMap = new HashMap<String, Object>();
            localParamsMap.put(TASK_TYPE, taskDefinitionLog.getTaskType());
            localParamsMap.put(LOCAL_PARAMS_LIST, localParamsList);
            if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)localParamsList)) continue;
            localUserDefParams.put(taskDefinitionLog.getName(), localParamsMap);
        }
        return localUserDefParams;
    }

    @Override
    public Map<String, Object> viewGantt(long projectCode, Integer workflowInstanceId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        WorkflowInstance workflowInstance = this.workflowInstanceMapper.queryDetailById(workflowInstanceId.intValue());
        if (workflowInstance == null) {
            log.error("workflow instance does not exist, projectCode:{}, workflowInstanceId:{}.", (Object)projectCode, (Object)workflowInstanceId);
            this.putMsg(result, Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId);
            return result;
        }
        WorkflowDefinitionLog workflowDefinition = this.workflowDefinitionLogMapper.queryByDefinitionCodeAndVersion(workflowInstance.getWorkflowDefinitionCode().longValue(), workflowInstance.getWorkflowDefinitionVersion());
        if (workflowDefinition == null || projectCode != workflowDefinition.getProjectCode()) {
            log.error("workflow definition does not exist, projectCode:{}, workflowDefinitionCode:{}.", (Object)projectCode, (Object)workflowInstance.getWorkflowDefinitionCode());
            this.putMsg(result, Status.WORKFLOW_INSTANCE_NOT_EXIST, workflowInstanceId);
            return result;
        }
        GanttDto ganttDto = new GanttDto();
        DAG dag = this.processService.genDagGraph((WorkflowDefinition)workflowDefinition);
        List nodeList = dag.topologicalSort();
        ganttDto.setTaskNames(nodeList);
        ArrayList<Task> taskList = new ArrayList<Task>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)nodeList)) {
            List taskInstances = this.taskInstanceMapper.queryByWorkflowInstanceIdsAndTaskCodes(Collections.singletonList(workflowInstanceId), nodeList);
            for (Long node : nodeList) {
                TaskInstance taskInstance = null;
                for (TaskInstance instance : taskInstances) {
                    if (instance.getWorkflowInstanceId() != workflowInstanceId.intValue() || instance.getTaskCode() != node.longValue()) continue;
                    taskInstance = instance;
                    break;
                }
                if (taskInstance == null) continue;
                Date startTime = taskInstance.getStartTime() == null ? new Date() : taskInstance.getStartTime();
                Date endTime = taskInstance.getEndTime() == null ? new Date() : taskInstance.getEndTime();
                Task task = new Task();
                task.setTaskName(taskInstance.getName());
                task.getStartDate().add(startTime.getTime());
                task.getEndDate().add(endTime.getTime());
                task.setIsoStart(startTime);
                task.setIsoEnd(endTime);
                task.setStatus(taskInstance.getState().name());
                task.setExecutionDate(taskInstance.getStartTime());
                task.setDuration(DateUtils.format2Readable((long)(endTime.getTime() - startTime.getTime())));
                taskList.add(task);
            }
        }
        ganttDto.setTasks(taskList);
        result.put("data", ganttDto);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public List<WorkflowInstance> queryByWorkflowDefinitionCodeAndStatus(Long workflowDefinitionCode, int[] states) {
        return this.workflowInstanceMapper.queryByWorkflowDefinitionCodeAndStatus(workflowDefinitionCode, states);
    }

    @Override
    public List<WorkflowInstance> queryByWorkflowCodeVersionStatus(Long workflowDefinitionCode, int workflowDefinitionVersion, int[] states) {
        return this.workflowInstanceDao.queryByWorkflowCodeVersionStatus(workflowDefinitionCode, workflowDefinitionVersion, states);
    }

    @Override
    public List<WorkflowInstance> queryByWorkflowDefinitionCode(Long workflowDefinitionCode, int size) {
        return this.workflowInstanceMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode, size);
    }

    @Override
    public Map<String, Object> queryByTriggerCode(User loginUser, long projectCode, Long triggerCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:process-instance:list");
        if (result.get("status") != Status.SUCCESS || triggerCode == null) {
            return result;
        }
        List workflowInstances = this.workflowInstanceMapper.queryByTriggerCode(triggerCode);
        result.put("data", workflowInstances);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public void deleteWorkflowInstanceByWorkflowDefinitionCode(long workflowDefinitionCode) {
        List workflowInstances;
        while (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)(workflowInstances = this.workflowInstanceMapper.queryByWorkflowDefinitionCode(Long.valueOf(workflowDefinitionCode), 100)))) {
            log.info("Begin to delete workflow instance, workflow definition code: {}", (Object)workflowDefinitionCode);
            for (WorkflowInstance workflowInstance : workflowInstances) {
                if (!workflowInstance.getState().isFinished()) {
                    log.warn("Workflow instance is not finished cannot delete, workflow instance id:{}", (Object)workflowInstance.getId());
                    throw new ServiceException(Status.WORKFLOW_INSTANCE_STATE_OPERATION_ERROR, workflowInstance.getName(), workflowInstance.getState(), "delete");
                }
                this.deleteWorkflowInstanceById(workflowInstance.getId());
            }
            log.info("Success delete workflow instance, workflow definition code: {}, size: {}", (Object)workflowDefinitionCode, (Object)workflowInstances.size());
        }
    }

    @Override
    public void deleteWorkflowInstanceById(int workflowInstanceId) {
        this.taskInstanceService.deleteByWorkflowInstanceId(workflowInstanceId);
        this.deleteSubWorkflowInstanceIfNeeded(workflowInstanceId);
        this.alertDao.deleteByWorkflowInstanceId(Integer.valueOf(workflowInstanceId));
        this.workflowInstanceDao.deleteById((Serializable)Integer.valueOf(workflowInstanceId));
    }

    private void deleteSubWorkflowInstanceIfNeeded(int workflowInstanceId) {
        List subWorkflowInstanceIds = this.workflowInstanceMapDao.querySubWorkflowInstanceIds(workflowInstanceId);
        if (CollectionUtils.isEmpty((Collection)subWorkflowInstanceIds)) {
            return;
        }
        for (Integer subWorkflowInstanceId : subWorkflowInstanceIds) {
            this.deleteWorkflowInstanceById(subWorkflowInstanceId);
        }
        this.workflowInstanceMapDao.deleteByParentId(workflowInstanceId);
    }
}

