/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.audit.operator.impl;

import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.audit.OperatorUtils;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.audit.operator.BaseAuditOperator;
import org.apache.dolphinscheduler.common.enums.AuditOperationType;
import org.apache.dolphinscheduler.dao.entity.AuditLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowAuditOperatorImpl
extends BaseAuditOperator {
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;

    @Override
    public void modifyAuditOperationType(AuditType auditType, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
        AuditOperationType auditOperationType = OperatorUtils.modifyReleaseOperationType(auditType, paramsMap);
        auditLogList.forEach(auditLog -> auditLog.setOperationType(auditOperationType.getName()));
    }

    @Override
    protected void setObjectByParam(String[] paramNameArr, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
        if (paramNameArr[0].equals("codes") || paramNameArr[0].equals("workflowDefinitionCodes") || paramNameArr[0].equals("workflowInstanceIds")) {
            super.setObjectByParamArr(paramNameArr, paramsMap, auditLogList);
        } else {
            super.setObjectByParam(paramNameArr, paramsMap, auditLogList);
        }
        if (paramsMap.containsKey("version")) {
            if (paramsMap.get("version") != null) {
                auditLogList.get(0).setDetail(paramsMap.get("version").toString());
            } else {
                auditLogList.get(0).setDetail("latest");
            }
        }
    }

    @Override
    protected String getObjectNameFromIdentity(Object identity) {
        Long objId = this.toLong(identity);
        if (objId == -1L) {
            return "";
        }
        WorkflowDefinition obj = this.workflowDefinitionMapper.queryByCode(objId.longValue());
        return obj == null ? "" : obj.getName();
    }
}

