/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.workflow;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowBackFillRequest;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.utils.WorkflowUtils;
import org.apache.dolphinscheduler.api.validator.ITransformer;
import org.apache.dolphinscheduler.api.validator.workflow.BackfillWorkflowDTO;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.repository.ProjectDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionDao;
import org.apache.dolphinscheduler.plugin.task.api.utils.PropertyUtils;
import org.apache.dolphinscheduler.service.cron.CronUtils;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BackfillWorkflowRequestTransformer
implements ITransformer<WorkflowBackFillRequest, BackfillWorkflowDTO> {
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private WorkflowDefinitionDao workflowDefinitionDao;

    @Override
    public BackfillWorkflowDTO transform(WorkflowBackFillRequest workflowBackFillRequest) {
        BackfillWorkflowDTO.BackfillParamsDTO backfillParams = this.transformBackfillParamsDTO(workflowBackFillRequest);
        BackfillWorkflowDTO backfillWorkflowDTO = BackfillWorkflowDTO.builder().loginUser(workflowBackFillRequest.getLoginUser()).startNodes(WorkflowUtils.parseStartNodeList(workflowBackFillRequest.getStartNodes())).failureStrategy(workflowBackFillRequest.getFailureStrategy()).taskDependType(workflowBackFillRequest.getTaskDependType()).execType(workflowBackFillRequest.getExecType()).warningType(workflowBackFillRequest.getWarningType()).warningGroupId(workflowBackFillRequest.getWarningGroupId()).runMode(workflowBackFillRequest.getBackfillRunMode()).workflowInstancePriority(workflowBackFillRequest.getWorkflowInstancePriority()).workerGroup(workflowBackFillRequest.getWorkerGroup()).tenantCode(workflowBackFillRequest.getTenantCode()).environmentCode(workflowBackFillRequest.getEnvironmentCode()).startParamList(PropertyUtils.startParamsTransformPropertyList((String)workflowBackFillRequest.getStartParamList())).dryRun(workflowBackFillRequest.getDryRun()).testFlag(workflowBackFillRequest.getTestFlag()).triggerCode(CodeGenerateUtils.genCode()).backfillParams(backfillParams).build();
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)this.workflowDefinitionDao.queryByCode(workflowBackFillRequest.getWorkflowDefinitionCode()).orElseThrow(() -> new ServiceException("Cannot find the workflow: " + workflowBackFillRequest.getWorkflowDefinitionCode()));
        backfillWorkflowDTO.setWorkflowDefinition(workflowDefinition);
        return backfillWorkflowDTO;
    }

    private BackfillWorkflowDTO.BackfillParamsDTO transformBackfillParamsDTO(WorkflowBackFillRequest workflowBackFillRequest) {
        List<ZonedDateTime> backfillDateList = this.parseBackfillDateList(workflowBackFillRequest);
        return BackfillWorkflowDTO.BackfillParamsDTO.builder().runMode(workflowBackFillRequest.getBackfillRunMode()).expectedParallelismNumber(workflowBackFillRequest.getExpectedParallelismNumber()).backfillDateList(backfillDateList).backfillDependentMode(workflowBackFillRequest.getBackfillDependentMode()).allLevelDependent(workflowBackFillRequest.isAllLevelDependent()).executionOrder(workflowBackFillRequest.getExecutionOrder()).build();
    }

    private List<ZonedDateTime> parseBackfillDateList(WorkflowBackFillRequest workflowBackFillRequest) {
        WorkflowBackFillRequest.BackfillTime backfillTime = workflowBackFillRequest.getBackfillTime();
        List schedules = this.processService.queryReleaseSchedulerListByWorkflowDefinitionCode(workflowBackFillRequest.getWorkflowDefinitionCode());
        if (StringUtils.isNotEmpty((CharSequence)backfillTime.getComplementStartDate()) && StringUtils.isNotEmpty((CharSequence)backfillTime.getComplementEndDate())) {
            return CronUtils.getSelfFireDateList((ZonedDateTime)DateUtils.stringToZoneDateTime((String)backfillTime.getComplementStartDate()), (ZonedDateTime)DateUtils.stringToZoneDateTime((String)backfillTime.getComplementEndDate()), (List)schedules);
        }
        if (StringUtils.isNotEmpty((CharSequence)backfillTime.getComplementScheduleDateList())) {
            return Arrays.stream(backfillTime.getComplementScheduleDateList().split(",")).distinct().map(DateUtils::stringToZoneDateTime).collect(Collectors.toList());
        }
        throw new ServiceException("backfillTime: " + backfillTime + " is invalid");
    }
}

