/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.google.common.primitives.Bytes;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.LoggerService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ResponseTaskLog;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.common.ILogService;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogFileDownloadRequest;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogFileDownloadResponse;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogPageQueryRequest;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogPageQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoggerServiceImpl
extends BaseServiceImpl
implements LoggerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggerServiceImpl.class);
    private static final String LOG_HEAD_FORMAT = "[LOG-PATH]: %s, [HOST]: %s%s";
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;

    @Override
    public Result<ResponseTaskLog> queryLog(User loginUser, int taskInstId, int skipLineNum, int limit) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(taskInstId));
        if (taskInstance == null) {
            log.error("Task instance does not exist, taskInstanceId:{}.", (Object)taskInstId);
            return Result.error(Status.TASK_INSTANCE_NOT_FOUND);
        }
        if (StringUtils.isBlank((CharSequence)taskInstance.getHost())) {
            log.error("Host of task instance is null, taskInstanceId:{}.", (Object)taskInstId);
            return Result.error(Status.TASK_INSTANCE_HOST_IS_NULL);
        }
        this.projectService.checkProjectAndAuthThrowException(loginUser, taskInstance.getProjectCode(), "project:log:detail");
        Result<ResponseTaskLog> result = new Result<ResponseTaskLog>(Status.SUCCESS.getCode(), Status.SUCCESS.getMsg());
        String log = this.queryLog(taskInstance, skipLineNum, limit);
        int lineNum = log.split("\\r\\n").length;
        result.setData(new ResponseTaskLog(lineNum, log));
        return result;
    }

    @Override
    public byte[] getLogBytes(User loginUser, int taskInstId) {
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(taskInstId));
        if (taskInstance == null || StringUtils.isBlank((CharSequence)taskInstance.getHost())) {
            throw new ServiceException("task instance is null or host is null");
        }
        Project project = this.projectMapper.queryProjectByTaskInstanceId(taskInstId);
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:log:download-log");
        return this.getLogBytes(taskInstance);
    }

    @Override
    public String queryLog(User loginUser, long projectCode, int taskInstId, int skipLineNum, int limit) {
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:log:detail");
        TaskInstance task = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(taskInstId));
        if (task == null || StringUtils.isBlank((CharSequence)task.getHost())) {
            throw new ServiceException(Status.TASK_INSTANCE_NOT_FOUND);
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(task.getTaskCode());
        if (taskDefinition != null && projectCode != taskDefinition.getProjectCode()) {
            throw new ServiceException(Status.TASK_INSTANCE_NOT_FOUND, taskInstId);
        }
        return this.queryLog(task, skipLineNum, limit);
    }

    @Override
    public byte[] getLogBytes(User loginUser, long projectCode, int taskInstId) {
        this.projectService.checkProjectAndAuthThrowException(loginUser, projectCode, "project:log:download-log");
        TaskInstance task = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(taskInstId));
        if (task == null || StringUtils.isBlank((CharSequence)task.getHost())) {
            throw new ServiceException("task instance is null or host is null");
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(task.getTaskCode());
        if (taskDefinition != null && projectCode != taskDefinition.getProjectCode()) {
            throw new ServiceException("task instance does not exist in project");
        }
        return this.getLogBytes(task);
    }

    private String queryLog(TaskInstance taskInstance, int skipLineNum, int limit) {
        String logPath = taskInstance.getLogPath();
        log.info("Query task instance log, taskInstanceId:{}, taskInstanceName:{}, host: {}, logPath:{}", new Object[]{taskInstance.getId(), taskInstance.getName(), taskInstance.getHost(), logPath});
        if (StringUtils.isBlank((CharSequence)logPath)) {
            throw new ServiceException(Status.QUERY_TASK_INSTANCE_LOG_ERROR, "TaskInstanceLogPath is empty, maybe the taskInstance doesn't be dispatched");
        }
        StringBuilder sb = new StringBuilder();
        if (skipLineNum == 0) {
            String head = String.format(LOG_HEAD_FORMAT, logPath, taskInstance.getHost(), Constants.SYSTEM_LINE_SEPARATOR);
            sb.append(head);
        }
        try {
            TaskInstanceLogPageQueryRequest request = TaskInstanceLogPageQueryRequest.builder().taskInstanceId(taskInstance.getId()).taskInstanceLogAbsolutePath(logPath).skipLineNum(skipLineNum).limit(limit).build();
            TaskInstanceLogPageQueryResponse response = ((ILogService)Clients.withService(ILogService.class).withHost(taskInstance.getHost())).pageQueryTaskInstanceLog(request);
            String logContent = response.getLogContent();
            if (logContent != null) {
                sb.append(logContent);
            }
            return sb.toString();
        }
        catch (Throwable ex) {
            throw new ServiceException(Status.QUERY_TASK_INSTANCE_LOG_ERROR, ex.getMessage(), ex);
        }
    }

    private byte[] getLogBytes(TaskInstance taskInstance) {
        String host = taskInstance.getHost();
        String logPath = taskInstance.getLogPath();
        byte[] head = String.format(LOG_HEAD_FORMAT, logPath, host, Constants.SYSTEM_LINE_SEPARATOR).getBytes(StandardCharsets.UTF_8);
        try {
            TaskInstanceLogFileDownloadRequest request = new TaskInstanceLogFileDownloadRequest((long)taskInstance.getId().intValue(), logPath);
            TaskInstanceLogFileDownloadResponse response = ((ILogService)Clients.withService(ILogService.class).withHost(taskInstance.getHost())).getTaskInstanceWholeLogFileBytes(request);
            byte[] logBytes = response.getLogBytes();
            return Bytes.concat((byte[][])new byte[][]{head, logBytes});
        }
        catch (Exception ex) {
            log.error("Download TaskInstance: {} Log Error", (Object)taskInstance.getName(), (Object)ex);
            throw new ServiceException(Status.DOWNLOAD_TASK_INSTANCE_LOG_FILE_ERROR);
        }
    }
}

