/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.interceptor;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.metrics.ApiServerMetrics;
import org.apache.dolphinscheduler.api.security.Authenticator;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.thread.ThreadLocalContext;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoginHandlerInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginHandlerInterceptor.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private Authenticator authenticator;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        User user;
        ApiServerMetrics.incApiRequestCount();
        String token = request.getHeader("token");
        if (StringUtils.isEmpty((CharSequence)token)) {
            user = this.authenticator.getAuthUser(request);
            if (user == null) {
                response.setStatus(401);
                log.info("user does not exist");
                return false;
            }
        } else {
            user = this.userMapper.queryUserByToken(token, new Date());
            if (user == null) {
                response.setStatus(401);
                log.info("user token has expired");
                return false;
            }
        }
        if (user.getState() == Flag.NO.ordinal()) {
            response.setStatus(401);
            log.info(Status.USER_DISABLED.getMsg());
            return false;
        }
        request.setAttribute("session.user", (Object)user);
        ThreadLocalContext.getTimezoneThreadLocal().set(user.getTimeZone());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        ThreadLocalContext.getTimezoneThreadLocal().remove();
        int code = response.getStatus();
        if (code >= 200 && code < 300) {
            ApiServerMetrics.incApiResponse2xxCount();
        } else if (code >= 300 && code < 400) {
            ApiServerMetrics.incApiResponse3xxCount();
        } else if (code >= 400 && code < 500) {
            ApiServerMetrics.incApiResponse4xxCount();
        } else if (code >= 500 && code < 600) {
            ApiServerMetrics.incApiResponse5xxCount();
        }
    }
}

