/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow;

import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.executor.workflow.IExecutorDelegate;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRepeatRunningRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRepeatRunningResponse;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepeatRunningWorkflowInstanceExecutorDelegate
implements IExecutorDelegate<RepeatRunningWorkflowInstanceOperation, Void> {
    @Autowired
    private RegistryClient registryClient;

    @Override
    public Void execute(RepeatRunningWorkflowInstanceOperation workflowInstanceControlRequest) {
        WorkflowInstance workflowInstance = workflowInstanceControlRequest.workflowInstance;
        if (workflowInstance.getState() == null || !workflowInstance.getState().isFinished()) {
            throw new ServiceException(String.format("The workflow instance: %s status is %s, cannot repeat running", workflowInstance.getName(), workflowInstance.getState()));
        }
        Server masterServer = this.registryClient.getRandomServer(RegistryNodeType.MASTER).orElse(null);
        if (masterServer == null) {
            throw new ServiceException("no master server available");
        }
        WorkflowInstanceRepeatRunningRequest repeatRunningRequest = WorkflowInstanceRepeatRunningRequest.builder().workflowInstanceId(workflowInstance.getId()).userId(workflowInstanceControlRequest.executeUser.getId()).build();
        WorkflowInstanceRepeatRunningResponse repeatRunningResponse = ((IWorkflowControlClient)Clients.withService(IWorkflowControlClient.class).withHost(masterServer.getHost() + ":" + masterServer.getPort())).repeatTriggerWorkflowInstance(repeatRunningRequest);
        if (!repeatRunningResponse.isSuccess()) {
            throw new ServiceException("Repeat running workflow instance failed: " + repeatRunningResponse.getMessage());
        }
        return null;
    }

    public static class RepeatRunningWorkflowInstanceOperation {
        private final RepeatRunningWorkflowInstanceExecutorDelegate repeatRunningWorkflowInstanceExecutorDelegate;
        private WorkflowInstance workflowInstance;
        private User executeUser;

        public RepeatRunningWorkflowInstanceOperation(RepeatRunningWorkflowInstanceExecutorDelegate repeatRunningWorkflowInstanceExecutorDelegate) {
            this.repeatRunningWorkflowInstanceExecutorDelegate = repeatRunningWorkflowInstanceExecutorDelegate;
        }

        public RepeatRunningWorkflowInstanceOperation onWorkflowInstance(WorkflowInstance workflowInstance) {
            this.workflowInstance = workflowInstance;
            return this;
        }

        public RepeatRunningWorkflowInstanceOperation byUser(User executeUser) {
            this.executeUser = executeUser;
            return this;
        }

        public void execute() {
            this.repeatRunningWorkflowInstanceExecutorDelegate.execute(this);
        }
    }
}

