/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.workflow;

import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.executor.workflow.IExecutorDelegate;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverSuspendTasksRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverSuspendTasksResponse;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecoverSuspendedWorkflowInstanceExecutorDelegate
implements IExecutorDelegate<RecoverSuspendedWorkflowInstanceOperation, Void> {
    @Autowired
    private RegistryClient registryClient;

    @Override
    public Void execute(RecoverSuspendedWorkflowInstanceOperation workflowInstanceControlRequest) {
        WorkflowInstance workflowInstance = workflowInstanceControlRequest.workflowInstance;
        if (!workflowInstance.getState().isPause() && !workflowInstance.getState().isStop()) {
            throw new ServiceException(String.format("The workflow instance: %s state is %s, cannot recovery", workflowInstance.getName(), workflowInstance.getState()));
        }
        Server masterServer = this.registryClient.getRandomServer(RegistryNodeType.MASTER).orElse(null);
        if (masterServer == null) {
            throw new ServiceException("no master server available");
        }
        WorkflowInstanceRecoverSuspendTasksRequest recoverSuspendTaskRequest = WorkflowInstanceRecoverSuspendTasksRequest.builder().workflowInstanceId(workflowInstance.getId()).userId(workflowInstanceControlRequest.executeUser.getId()).build();
        WorkflowInstanceRecoverSuspendTasksResponse recoverSuspendTaskResponse = ((IWorkflowControlClient)Clients.withService(IWorkflowControlClient.class).withHost(masterServer.getHost() + ":" + masterServer.getPort())).triggerFromSuspendTasks(recoverSuspendTaskRequest);
        if (!recoverSuspendTaskResponse.isSuccess()) {
            throw new ServiceException("Recover workflow instance failed: " + recoverSuspendTaskResponse.getMessage());
        }
        return null;
    }

    public static class RecoverSuspendedWorkflowInstanceOperation {
        private final RecoverSuspendedWorkflowInstanceExecutorDelegate recoverSuspendedWorkflowInstanceExecutorDelegate;
        private WorkflowInstance workflowInstance;
        private User executeUser;

        public RecoverSuspendedWorkflowInstanceOperation(RecoverSuspendedWorkflowInstanceExecutorDelegate recoverSuspendedWorkflowInstanceExecutorDelegate) {
            this.recoverSuspendedWorkflowInstanceExecutorDelegate = recoverSuspendedWorkflowInstanceExecutorDelegate;
        }

        public RecoverSuspendedWorkflowInstanceOperation onWorkflowInstance(WorkflowInstance workflowInstance) {
            this.workflowInstance = workflowInstance;
            return this;
        }

        public RecoverSuspendedWorkflowInstanceOperation byUser(User executeUser) {
            this.executeUser = executeUser;
            return this;
        }

        public void execute() {
            this.recoverSuspendedWorkflowInstanceExecutorDelegate.execute(this);
        }
    }
}

