/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.webexteams;

import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum WebexTeamsDestination {
    ROOM_ID(0, "roomId"),
    PERSON_EMAIL(1, "personEmail"),
    PERSON_ID(2, "personId");

    private final int code;
    private final String descp;
    private static final Map<String, WebexTeamsDestination> WEBEX_TEAMS_DESTINATION_MAP;

    private WebexTeamsDestination(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public static WebexTeamsDestination of(String descp) {
        if (WEBEX_TEAMS_DESTINATION_MAP.containsKey(descp)) {
            return WEBEX_TEAMS_DESTINATION_MAP.get(descp);
        }
        return null;
    }

    static {
        WEBEX_TEAMS_DESTINATION_MAP = Arrays.stream(WebexTeamsDestination.values()).collect(Collectors.toMap(WebexTeamsDestination::getDescp, Functions.identity()));
    }
}

